/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sample;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.HeaderViewListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.SectionIndexer;

public class AbLetterFilterListView
extends RelativeLayout {
    private Context context;
    private SectionIndexer sectionIndexter = null;
    private ListView listView;
    private LetterView letterView;

    public AbLetterFilterListView(Context context) {
        super(context);
        this.init(context);
    }

    public AbLetterFilterListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AbLetterFilterListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int count = this.getChildCount();
        if (count < 1) {
            throw new IllegalArgumentException("this layout must contain 1 child views,and AdapterView  must in the first position!");
        }
        View view = this.getChildAt(0);
        AdapterView adapterView = null;
        if (view instanceof AdapterView) {
            adapterView = (AdapterView)view;
            this.listView = (ListView)adapterView;
            this.sectionIndexter = (SectionIndexer)this.listView.getAdapter();
            this.letterView = new LetterView(this.context);
            this.letterView.setListView(this.listView);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(60, -2);
            layoutParams.addRule(11, -1);
            layoutParams.topMargin = 10;
            layoutParams.rightMargin = 10;
            layoutParams.bottomMargin = 10;
            this.addView(this.letterView, (ViewGroup.LayoutParams)layoutParams);
        }
        if (adapterView == null) {
            throw new IllegalArgumentException("must contain a AdapterView in this layout!");
        }
    }

    public class LetterView
    extends View {
        private ListView listView;
        private char[] l;
        private Paint paint;
        private float widthCenter;
        private float singleHeight;
        private GradientDrawable gradientDrawable;

        public LetterView(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.gradientDrawable = null;
            this.init();
        }

        public LetterView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.gradientDrawable = null;
            this.init();
        }

        public LetterView(Context context) {
            super(context);
            this.gradientDrawable = null;
            this.init();
        }

        private void init() {
            this.l = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '#'};
            this.paint = new Paint();
            this.paint.setColor(Color.parseColor((String)"#949494"));
            this.paint.setTypeface(Typeface.DEFAULT_BOLD);
            this.paint.setTextSize(22.0f);
            this.paint.setAntiAlias(true);
            this.paint.setTextAlign(Paint.Align.CENTER);
            this.gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{-1716473680, -1716473680});
            this.gradientDrawable.setCornerRadius(30.0f);
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            float height = this.getHeight();
            this.singleHeight = height / (float)this.l.length;
            this.widthCenter = (float)this.getMeasuredWidth() / 2.0f;
            int i = 0;
            while (i < this.l.length) {
                canvas.drawText(String.valueOf(this.l[i]), this.widthCenter, this.singleHeight + (float)i * this.singleHeight, this.paint);
                ++i;
            }
        }

        public ListView getListView() {
            return this.listView;
        }

        public void setListView(ListView listView) {
            this.listView = listView;
        }

        public boolean onTouchEvent(MotionEvent event) {
            super.onTouchEvent(event);
            int i = (int)event.getY();
            int div = (int)this.singleHeight;
            int idx = 0;
            if (div != 0) {
                idx = i / div;
            }
            if (idx >= this.l.length) {
                idx = this.l.length - 1;
            } else if (idx < 0) {
                idx = 0;
            }
            switch (event.getAction()) {
                case 1: {
                    this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
                    break;
                }
                case 0: 
                case 2: {
                    int position;
                    this.setBackgroundDrawable((Drawable)this.gradientDrawable);
                    if (this.listView.getAdapter() == null) break;
                    HeaderViewListAdapter listAdapter = (HeaderViewListAdapter)this.listView.getAdapter();
                    if (AbLetterFilterListView.this.sectionIndexter == null) {
                        AbLetterFilterListView.this.sectionIndexter = (SectionIndexer)listAdapter.getWrappedAdapter();
                    }
                    if ((position = AbLetterFilterListView.this.sectionIndexter.getPositionForSection((int)this.l[idx])) == -1) {
                        return true;
                    }
                    this.listView.setSelection(position);
                }
            }
            return true;
        }
    }
}

