/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.pullview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import com.ab.view.pullview.AbListViewFooter;
import com.ab.view.pullview.AbListViewHeader;

public class AbPullToRefreshView
extends LinearLayout {
    private Context mContext = null;
    private boolean mEnablePullRefresh = true;
    private boolean mEnableLoadMore = true;
    private int mLastMotionX;
    private int mLastMotionY;
    private AbListViewHeader mHeaderView;
    private AbListViewFooter mFooterView;
    private AdapterView<?> mAdapterView;
    private ScrollView mScrollView;
    private int mHeaderViewHeight;
    private int mFooterViewHeight;
    private int mPullState;
    private static final int PULL_UP_STATE = 0;
    private static final int PULL_DOWN_STATE = 1;
    private int mCount = 0;
    private boolean mPullRefreshing = false;
    private boolean mPullLoading = false;
    private OnFooterLoadListener mOnFooterLoadListener;
    private OnHeaderRefreshListener mOnHeaderRefreshListener;

    public AbPullToRefreshView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AbPullToRefreshView(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.setOrientation(1);
        this.addHeaderView();
    }

    private void addHeaderView() {
        this.mHeaderView = new AbListViewHeader(this.mContext);
        this.mHeaderViewHeight = this.mHeaderView.getHeaderHeight();
        this.mHeaderView.setGravity(80);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, this.mHeaderViewHeight);
        params.topMargin = -this.mHeaderViewHeight;
        this.addView((View)this.mHeaderView, (ViewGroup.LayoutParams)params);
    }

    private void addFooterView() {
        this.mFooterView = new AbListViewFooter(this.mContext);
        this.mFooterViewHeight = this.mFooterView.getFooterHeight();
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, this.mFooterViewHeight);
        this.addView((View)this.mFooterView, (ViewGroup.LayoutParams)params);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.addFooterView();
        this.initContentAdapterView();
    }

    private void initContentAdapterView() {
        int count = this.getChildCount();
        if (count < 3) {
            throw new IllegalArgumentException("this layout must contain 3 child views,and AdapterView or ScrollView must in the second position!");
        }
        View view = null;
        int i = 0;
        while (i < count - 1) {
            view = this.getChildAt(i);
            if (view instanceof AdapterView) {
                this.mAdapterView = (AdapterView)view;
            }
            if (view instanceof ScrollView) {
                this.mScrollView = (ScrollView)view;
            }
            ++i;
        }
        if (this.mAdapterView == null && this.mScrollView == null) {
            throw new IllegalArgumentException("must contain a AdapterView or ScrollView in this layout!");
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        int x = (int)e.getX();
        int y = (int)e.getY();
        switch (e.getAction()) {
            case 0: {
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                break;
            }
            case 2: {
                int deltaX = x - this.mLastMotionX;
                int deltaY = y - this.mLastMotionY;
                if (Math.abs(deltaX) >= Math.abs(deltaY) || Math.abs(deltaY) <= 10 || !this.isRefreshViewScroll(deltaY)) break;
                return true;
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                break;
            }
            case 2: {
                int deltaY = y - this.mLastMotionY;
                if (this.mPullState == 1) {
                    this.headerPrepareToRefresh(deltaY);
                } else if (this.mPullState == 0) {
                    this.footerPrepareToRefresh(deltaY);
                }
                this.mLastMotionY = y;
                break;
            }
            case 1: 
            case 3: {
                int topMargin = this.getHeaderTopMargin();
                if (this.mPullState == 1) {
                    if (topMargin >= 0) {
                        this.headerRefreshing();
                        break;
                    }
                    this.setHeaderTopMargin(-this.mHeaderViewHeight);
                    break;
                }
                if (this.mPullState != 0) break;
                if (Math.abs(topMargin) >= this.mHeaderViewHeight + this.mFooterViewHeight) {
                    this.footerLoading();
                    break;
                }
                this.setHeaderTopMargin(-this.mHeaderViewHeight);
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean isRefreshViewScroll(int deltaY) {
        View child;
        if (this.mPullRefreshing || this.mPullLoading) {
            return false;
        }
        if (this.mAdapterView != null) {
            if (deltaY > 0) {
                if (!this.mEnablePullRefresh) {
                    return false;
                }
                child = this.mAdapterView.getChildAt(0);
                if (child == null) {
                    return false;
                }
                if (this.mAdapterView.getFirstVisiblePosition() == 0 && child.getTop() == 0) {
                    this.mPullState = 1;
                    return true;
                }
                int top = child.getTop();
                int padding = this.mAdapterView.getPaddingTop();
                if (this.mAdapterView.getFirstVisiblePosition() == 0 && Math.abs(top - padding) <= 11) {
                    this.mPullState = 1;
                    return true;
                }
            } else if (deltaY < 0) {
                if (!this.mEnableLoadMore) {
                    return false;
                }
                View lastChild = this.mAdapterView.getChildAt(this.mAdapterView.getChildCount() - 1);
                if (lastChild == null) {
                    return false;
                }
                if (lastChild.getBottom() <= this.getHeight() && this.mAdapterView.getLastVisiblePosition() == this.mAdapterView.getCount() - 1) {
                    this.mPullState = 0;
                    return true;
                }
            }
        }
        if (this.mScrollView != null) {
            child = this.mScrollView.getChildAt(0);
            if (deltaY > 0 && this.mScrollView.getScrollY() == 0) {
                this.mPullState = 1;
                return true;
            }
            if (deltaY < 0 && child.getMeasuredHeight() <= this.getHeight() + this.mScrollView.getScrollY()) {
                this.mPullState = 0;
                return true;
            }
        }
        return false;
    }

    private void headerPrepareToRefresh(int deltaY) {
        if (this.mPullRefreshing || this.mPullLoading) {
            return;
        }
        int newTopMargin = this.updateHeaderViewTopMargin(deltaY);
        if (newTopMargin >= 0 && this.mHeaderView.getState() != 2) {
            this.mHeaderView.setState(1);
        } else if (newTopMargin < 0 && newTopMargin > -this.mHeaderViewHeight) {
            this.mHeaderView.setState(0);
        }
    }

    private void footerPrepareToRefresh(int deltaY) {
        if (this.mPullRefreshing || this.mPullLoading) {
            return;
        }
        int newTopMargin = this.updateHeaderViewTopMargin(deltaY);
        if (Math.abs(newTopMargin) >= this.mHeaderViewHeight + this.mFooterViewHeight && this.mFooterView.getState() != 2) {
            this.mFooterView.setState(1);
        } else if (Math.abs(newTopMargin) < this.mHeaderViewHeight + this.mFooterViewHeight) {
            this.mFooterView.setState(2);
        }
    }

    private int updateHeaderViewTopMargin(int deltaY) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mHeaderView.getLayoutParams();
        float newTopMargin = (float)params.topMargin + (float)deltaY * 0.3f;
        if (deltaY > 0 && this.mPullState == 0 && Math.abs(params.topMargin) <= this.mHeaderViewHeight) {
            return params.topMargin;
        }
        if (deltaY < 0 && this.mPullState == 1 && Math.abs(params.topMargin) >= this.mHeaderViewHeight) {
            return params.topMargin;
        }
        params.topMargin = (int)newTopMargin;
        this.mHeaderView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.invalidate();
        return params.topMargin;
    }

    public void headerRefreshing() {
        this.mPullRefreshing = true;
        this.mHeaderView.setState(2);
        this.setHeaderTopMargin(0);
        if (this.mOnHeaderRefreshListener != null) {
            this.mOnHeaderRefreshListener.onHeaderRefresh(this);
        }
    }

    private void footerLoading() {
        this.mPullLoading = true;
        int top = this.mHeaderViewHeight + this.mFooterViewHeight;
        this.setHeaderTopMargin(-top);
        if (this.mOnFooterLoadListener != null) {
            this.mOnFooterLoadListener.onFooterLoad(this);
        }
    }

    private void setHeaderTopMargin(int topMargin) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mHeaderView.getLayoutParams();
        params.topMargin = topMargin;
        this.mHeaderView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.invalidate();
    }

    public void onHeaderRefreshFinish() {
        this.setHeaderTopMargin(-this.mHeaderViewHeight);
        this.mHeaderView.setState(0);
        if (this.mAdapterView != null) {
            this.mCount = this.mAdapterView.getCount();
            if (this.mCount > 0) {
                this.mFooterView.setState(1);
            } else {
                this.mFooterView.setState(4);
            }
        } else {
            this.mFooterView.setState(1);
        }
        this.mPullRefreshing = false;
    }

    public void onFooterLoadFinish() {
        this.setHeaderTopMargin(-this.mHeaderViewHeight);
        this.mHeaderView.setState(0);
        if (this.mAdapterView != null) {
            int countNew = this.mAdapterView.getCount();
            if (countNew > this.mCount) {
                this.mFooterView.setState(1);
            } else {
                this.mFooterView.setState(3);
            }
        } else {
            this.mFooterView.setState(1);
        }
        this.mPullLoading = false;
    }

    private int getHeaderTopMargin() {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mHeaderView.getLayoutParams();
        return params.topMargin;
    }

    public void setOnHeaderRefreshListener(OnHeaderRefreshListener headerRefreshListener) {
        this.mOnHeaderRefreshListener = headerRefreshListener;
    }

    public void setOnFooterLoadListener(OnFooterLoadListener footerLoadListener) {
        this.mOnFooterLoadListener = footerLoadListener;
    }

    public void setPullRefreshEnable(boolean enable) {
        this.mEnablePullRefresh = enable;
    }

    public void setLoadMoreEnable(boolean enable) {
        this.mEnableLoadMore = enable;
    }

    public boolean isEnablePullRefresh() {
        return this.mEnablePullRefresh;
    }

    public boolean isEnableLoadMore() {
        return this.mEnableLoadMore;
    }

    public AbListViewHeader getHeaderView() {
        return this.mHeaderView;
    }

    public AbListViewFooter getFooterView() {
        return this.mFooterView;
    }

    public ProgressBar getHeaderProgressBar() {
        return this.mHeaderView.getHeaderProgressBar();
    }

    public ProgressBar getFooterProgressBar() {
        return this.mFooterView.getFooterProgressBar();
    }

    public static interface OnFooterLoadListener {
        public void onFooterLoad(AbPullToRefreshView var1);
    }

    public static interface OnHeaderRefreshListener {
        public void onHeaderRefresh(AbPullToRefreshView var1);
    }
}

