/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.pullview;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.ab.util.AbViewUtil;

public class AbListViewFooter
extends LinearLayout {
    private Context mContext;
    private int mState = -1;
    public static final int STATE_READY = 1;
    public static final int STATE_LOADING = 2;
    public static final int STATE_NO = 3;
    public static final int STATE_EMPTY = 4;
    private LinearLayout footerView;
    private ProgressBar footerProgressBar;
    private TextView footerTextView;
    private int footerHeight;

    public AbListViewFooter(Context context) {
        super(context);
        this.initView(context);
    }

    public AbListViewFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
        this.setState(1);
    }

    private void initView(Context context) {
        this.mContext = context;
        this.footerView = new LinearLayout(context);
        this.footerView.setOrientation(0);
        this.footerView.setGravity(17);
        this.footerView.setMinimumHeight(AbViewUtil.scale(this.mContext, 100.0f));
        this.footerTextView = new TextView(context);
        this.footerTextView.setGravity(16);
        this.setTextColor(Color.rgb((int)107, (int)107, (int)107));
        AbViewUtil.setTextSize(this.footerTextView, 30.0f);
        AbViewUtil.setPadding((View)this.footerView, 0, 10, 0, 10);
        this.footerProgressBar = new ProgressBar(context, null, 0x1010077);
        this.footerProgressBar.setVisibility(8);
        LinearLayout.LayoutParams layoutParamsWW = new LinearLayout.LayoutParams(-2, -2);
        layoutParamsWW.gravity = 17;
        layoutParamsWW.width = AbViewUtil.scale(this.mContext, 50.0f);
        layoutParamsWW.height = AbViewUtil.scale(this.mContext, 50.0f);
        layoutParamsWW.rightMargin = AbViewUtil.scale(this.mContext, 10.0f);
        this.footerView.addView((View)this.footerProgressBar, (ViewGroup.LayoutParams)layoutParamsWW);
        LinearLayout.LayoutParams layoutParamsWW1 = new LinearLayout.LayoutParams(-2, -2);
        this.footerView.addView((View)this.footerTextView, (ViewGroup.LayoutParams)layoutParamsWW1);
        LinearLayout.LayoutParams layoutParamsFW = new LinearLayout.LayoutParams(-1, -2);
        this.addView((View)this.footerView, (ViewGroup.LayoutParams)layoutParamsFW);
        AbViewUtil.measureView((View)this);
        this.footerHeight = this.getMeasuredHeight();
    }

    public void setState(int state) {
        if (state == 1) {
            this.footerView.setVisibility(0);
            this.footerTextView.setVisibility(0);
            this.footerProgressBar.setVisibility(8);
            this.footerTextView.setText((CharSequence)"\u8f7d\u5165\u66f4\u591a");
        } else if (state == 2) {
            this.footerView.setVisibility(0);
            this.footerTextView.setVisibility(0);
            this.footerProgressBar.setVisibility(0);
            this.footerTextView.setText((CharSequence)"\u6b63\u5728\u52a0\u8f7d...");
        } else if (state == 3) {
            this.footerView.setVisibility(8);
            this.footerTextView.setVisibility(0);
            this.footerProgressBar.setVisibility(8);
            this.footerTextView.setText((CharSequence)"\u6ca1\u6709\u4e86\uff01");
        } else if (state == 4) {
            this.footerView.setVisibility(8);
            this.footerTextView.setVisibility(8);
            this.footerProgressBar.setVisibility(8);
            this.footerTextView.setText((CharSequence)"\u6ca1\u6709\u6570\u636e");
        }
        this.mState = state;
    }

    public int getVisiableHeight() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.footerView.getLayoutParams();
        return lp.height;
    }

    public void hide() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.footerView.getLayoutParams();
        lp.height = 0;
        this.footerView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.footerView.setVisibility(8);
    }

    public void show() {
        this.footerView.setVisibility(0);
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.footerView.getLayoutParams();
        lp.height = -2;
        this.footerView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void setTextColor(int color) {
        this.footerTextView.setTextColor(color);
    }

    public void setTextSize(int size) {
        this.footerTextView.setTextSize((float)size);
    }

    public void setBackgroundColor(int color) {
        this.footerView.setBackgroundColor(color);
    }

    public ProgressBar getFooterProgressBar() {
        return this.footerProgressBar;
    }

    public void setFooterProgressBarDrawable(Drawable indeterminateDrawable) {
        this.footerProgressBar.setIndeterminateDrawable(indeterminateDrawable);
    }

    public int getFooterHeight() {
        return this.footerHeight;
    }

    public void setVisiableHeight(int height) {
        if (height < 0) {
            height = 0;
        }
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.footerView.getLayoutParams();
        lp.height = height;
        this.footerView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public int getState() {
        return this.mState;
    }
}

