/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.progress;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.EmbossMaskFilter;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;

@SuppressLint(value={"DrawAllocation"})
public class AbHorizontalProgressBar
extends View {
    private int progress = 0;
    private int max = 100;
    private Paint pathPaint = null;
    private Paint fillPaint = null;
    private int pathWidth = 35;
    private int width;
    private int height;
    private int pathColor = -987425;
    private int pathBorderColor = -2960956;
    private int[] fillColors = new int[]{-12717242, -16596970};
    private EmbossMaskFilter emboss = null;
    float[] direction = new float[]{1.0f, 1.0f, 1.0f};
    float light = 0.4f;
    float specular = 6.0f;
    float blur = 3.5f;
    private BlurMaskFilter mBlur = null;
    private AbOnProgressListener mAbOnProgressListener = null;
    private boolean reset = false;

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.invalidate();
        if (this.mAbOnProgressListener != null) {
            if (this.max <= this.progress) {
                this.mAbOnProgressListener.onComplete();
            } else {
                this.mAbOnProgressListener.onProgress(progress);
            }
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public AbHorizontalProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.pathPaint = new Paint();
        this.pathPaint.setAntiAlias(true);
        this.pathPaint.setFlags(1);
        this.pathPaint.setStyle(Paint.Style.FILL);
        this.pathPaint.setDither(true);
        this.fillPaint = new Paint();
        this.fillPaint.setAntiAlias(true);
        this.fillPaint.setFlags(1);
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.fillPaint.setDither(true);
        this.emboss = new EmbossMaskFilter(this.direction, this.light, this.specular, this.blur);
        this.mBlur = new BlurMaskFilter(20.0f, BlurMaskFilter.Blur.NORMAL);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.reset) {
            canvas.drawColor(0);
            this.reset = false;
        }
        this.width = this.getMeasuredWidth();
        this.height = this.getMeasuredHeight();
        this.pathPaint.setColor(this.pathColor);
        this.pathPaint.setStrokeWidth((float)this.pathWidth);
        this.pathPaint.setMaskFilter((MaskFilter)this.emboss);
        canvas.drawRect(0.0f, 0.0f, (float)this.width, (float)this.height, this.pathPaint);
        this.pathPaint.setColor(this.pathBorderColor);
        canvas.drawRect(0.0f, 0.0f, (float)this.width, (float)this.height, this.pathPaint);
        LinearGradient linearGradient = new LinearGradient(0.0f, 0.0f, (float)this.width, (float)this.height, this.fillColors[0], this.fillColors[1], Shader.TileMode.CLAMP);
        this.fillPaint.setShader((Shader)linearGradient);
        this.fillPaint.setMaskFilter((MaskFilter)this.mBlur);
        this.fillPaint.setStrokeCap(Paint.Cap.ROUND);
        this.fillPaint.setStrokeWidth((float)this.pathWidth);
        canvas.drawRect(0.0f, 0.0f, (float)this.progress / (float)this.max * (float)this.width, (float)this.height, this.fillPaint);
    }

    public AbOnProgressListener getAbOnProgressListener() {
        return this.mAbOnProgressListener;
    }

    public void setAbOnProgressListener(AbOnProgressListener mAbOnProgressListener) {
        this.mAbOnProgressListener = mAbOnProgressListener;
    }

    public void reset() {
        this.reset = true;
        this.progress = 0;
        this.invalidate();
    }

    public static interface AbOnProgressListener {
        public void onProgress(int var1);

        public void onComplete();
    }
}

