/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.cropimage;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.FaceDetector;
import android.os.Handler;
import android.view.View;
import com.ab.util.AbFileUtil;
import com.ab.view.cropimage.CropImageView;
import com.ab.view.cropimage.HighlightView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;

public class CropImage {
    public File FILE_LOCAL = null;
    public boolean mWaitingToPick;
    public boolean mSaving;
    public HighlightView mCrop;
    private Context mContext;
    private Handler mHandler;
    private CropImageView mImageView;
    private Bitmap mBitmap;
    Runnable mRunFaceDetection = new Runnable(){
        float mScale = 1.0f;
        Matrix mImageMatrix;
        FaceDetector.Face[] mFaces = new FaceDetector.Face[3];
        int mNumFaces;

        private void handleFace(FaceDetector.Face f) {
            PointF midPoint = new PointF();
            int r = (int)(f.eyesDistance() * this.mScale) * 2;
            f.getMidPoint(midPoint);
            midPoint.x *= this.mScale;
            midPoint.y *= this.mScale;
            int midX = (int)midPoint.x;
            int midY = (int)midPoint.y;
            HighlightView hv = new HighlightView((View)CropImage.this.mImageView);
            int width = CropImage.this.mBitmap.getWidth();
            int height = CropImage.this.mBitmap.getHeight();
            Rect imageRect = new Rect(0, 0, width, height);
            RectF faceRect = new RectF((float)midX, (float)midY, (float)midX, (float)midY);
            faceRect.inset((float)(-r), (float)(-r));
            if (faceRect.left < 0.0f) {
                faceRect.inset(-faceRect.left, -faceRect.left);
            }
            if (faceRect.top < 0.0f) {
                faceRect.inset(-faceRect.top, -faceRect.top);
            }
            if (faceRect.right > (float)imageRect.right) {
                faceRect.inset(faceRect.right - (float)imageRect.right, faceRect.right - (float)imageRect.right);
            }
            if (faceRect.bottom > (float)imageRect.bottom) {
                faceRect.inset(faceRect.bottom - (float)imageRect.bottom, faceRect.bottom - (float)imageRect.bottom);
            }
            hv.setup(this.mImageMatrix, imageRect, faceRect, false, true);
            CropImage.this.mImageView.add(hv);
        }

        private void makeDefault() {
            int cropWidth;
            HighlightView hv = new HighlightView((View)CropImage.this.mImageView);
            int width = CropImage.this.mBitmap.getWidth();
            int height = CropImage.this.mBitmap.getHeight();
            Rect imageRect = new Rect(0, 0, width, height);
            int cropHeight = cropWidth = Math.min(width, height) * 4 / 5;
            int x = (width - cropWidth) / 2;
            int y = (height - cropHeight) / 2;
            RectF cropRect = new RectF((float)x, (float)y, (float)(x + cropWidth), (float)(y + cropHeight));
            hv.setup(this.mImageMatrix, imageRect, cropRect, false, true);
            CropImage.this.mImageView.add(hv);
        }

        private Bitmap prepareBitmap() {
            if (CropImage.this.mBitmap == null) {
                return null;
            }
            if (CropImage.this.mBitmap.getWidth() > 256) {
                this.mScale = 256.0f / (float)CropImage.this.mBitmap.getWidth();
            }
            Matrix matrix = new Matrix();
            matrix.setScale(this.mScale, this.mScale);
            Bitmap faceBitmap = Bitmap.createBitmap((Bitmap)CropImage.this.mBitmap, (int)0, (int)0, (int)CropImage.this.mBitmap.getWidth(), (int)CropImage.this.mBitmap.getHeight(), (Matrix)matrix, (boolean)true);
            return faceBitmap;
        }

        @Override
        public void run() {
            this.mImageMatrix = CropImage.this.mImageView.getImageMatrix();
            Bitmap faceBitmap = this.prepareBitmap();
            this.mScale = 1.0f / this.mScale;
            if (faceBitmap != null) {
                FaceDetector detector = new FaceDetector(faceBitmap.getWidth(), faceBitmap.getHeight(), this.mFaces.length);
                this.mNumFaces = detector.findFaces(faceBitmap, this.mFaces);
            }
            if (faceBitmap != null && faceBitmap != CropImage.this.mBitmap) {
                faceBitmap.recycle();
            }
            CropImage.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    (this).CropImage.this.mWaitingToPick = mNumFaces > 1;
                    this.makeDefault();
                    CropImage.this.mImageView.invalidate();
                    if (((CropImage)(this).CropImage.this).mImageView.mHighlightViews.size() > 0) {
                        (this).CropImage.this.mCrop = ((CropImage)(this).CropImage.this).mImageView.mHighlightViews.get(0);
                        (this).CropImage.this.mCrop.setFocus(true);
                    }
                }
            });
        }
    };

    public CropImage(Context context, CropImageView imageView, Handler handler) {
        this.mContext = context;
        this.mImageView = imageView;
        this.mImageView.setCropImage(this);
        this.mHandler = handler;
        this.FILE_LOCAL = new File(AbFileUtil.getImageDownloadDir(context));
        if (!this.FILE_LOCAL.exists()) {
            this.FILE_LOCAL.mkdirs();
        }
    }

    public void crop(Bitmap bm) {
        this.mBitmap = bm;
        this.startFaceDetection();
    }

    public void startRotate(float d) {
        if (((Activity)this.mContext).isFinishing()) {
            return;
        }
        final float degrees = d;
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable mRunnable = new Runnable(){

            @Override
            public void run() {
                CropImage.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Matrix m = new Matrix();
                            m.setRotate(degrees);
                            Bitmap tb = Bitmap.createBitmap((Bitmap)CropImage.this.mBitmap, (int)0, (int)0, (int)CropImage.this.mBitmap.getWidth(), (int)CropImage.this.mBitmap.getHeight(), (Matrix)m, (boolean)false);
                            CropImage.this.mBitmap = tb;
                            CropImage.this.mImageView.resetView(tb);
                            if (((CropImage)(this).CropImage.this).mImageView.mHighlightViews.size() > 0) {
                                (this).CropImage.this.mCrop = ((CropImage)(this).CropImage.this).mImageView.mHighlightViews.get(0);
                                (this).CropImage.this.mCrop.setFocus(true);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        new Thread(new BackgroundJob("", mRunnable, this.mHandler)).start();
    }

    private void startFaceDetection() {
        if (((Activity)this.mContext).isFinishing()) {
            return;
        }
        Runnable mRunnable = new Runnable(){

            @Override
            public void run() {
                final CountDownLatch latch = new CountDownLatch(1);
                final Bitmap b = CropImage.this.mBitmap;
                CropImage.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (b != CropImage.this.mBitmap && b != null) {
                            CropImage.this.mImageView.setImageBitmapResetBase(b, true);
                            CropImage.this.mBitmap.recycle();
                            CropImage.this.mBitmap = b;
                        }
                        if (CropImage.this.mImageView.getScale() == 1.0f) {
                            CropImage.this.mImageView.center(true, true);
                        }
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                CropImage.this.mRunFaceDetection.run();
            }
        };
        new Thread(new BackgroundJob("", mRunnable, this.mHandler)).start();
    }

    public Bitmap cropAndSave() {
        Bitmap bmp = this.onSaveClicked(this.mBitmap);
        this.mImageView.mHighlightViews.clear();
        return bmp;
    }

    public Bitmap cropAndSave(Bitmap bm) {
        Bitmap bmp = this.onSaveClicked(bm);
        this.mImageView.mHighlightViews.clear();
        return bmp;
    }

    public void cropCancel() {
        this.mImageView.mHighlightViews.clear();
        this.mImageView.invalidate();
    }

    private Bitmap onSaveClicked(Bitmap bm) {
        if (this.mSaving) {
            return bm;
        }
        if (this.mCrop == null) {
            return bm;
        }
        this.mSaving = true;
        Rect r = this.mCrop.getCropRect();
        int width = 360;
        int height = 360;
        Bitmap croppedImage = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(croppedImage);
        Rect dstRect = new Rect(0, 0, width, height);
        canvas.drawBitmap(bm, r, dstRect, null);
        return croppedImage;
    }

    public String saveToLocal(Bitmap bitmap) {
        String mFileName = String.valueOf(System.currentTimeMillis()) + ".jpg";
        String path = this.FILE_LOCAL + File.separator + mFileName;
        try {
            FileOutputStream fos = new FileOutputStream(path);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 75, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return path;
    }

    public class BackgroundJob
    implements Runnable {
        private String message;
        private Runnable mJob;
        private Handler mHandler;

        public BackgroundJob(String m, Runnable job, Handler handler) {
            this.message = m;
            this.mJob = job;
            this.mHandler = handler;
        }

        @Override
        public void run() {
            final CountDownLatch latch = new CountDownLatch(1);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                this.mJob.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

