/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.ab.view.chart.LineChart;
import com.ab.view.chart.XYMultipleSeriesDataset;
import com.ab.view.chart.XYMultipleSeriesRenderer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TimeChart
extends LineChart {
    public static final String TYPE = "Time";
    public static final long DAY = 86400000L;
    private String mDateFormat;
    private Double mStartPoint;

    TimeChart() {
    }

    public TimeChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
    }

    public String getDateFormat() {
        return this.mDateFormat;
    }

    public void setDateFormat(String format) {
        this.mDateFormat = format;
    }

    @Override
    protected void drawXLabels(List<Double> xLabels, Double[] xTextLabelLocations, Canvas canvas, Paint paint, int left, int top, int bottom, double xPixelsPerUnit, double minX, double maxX) {
        int length = xLabels.size();
        if (length > 0) {
            boolean showLabels = this.mRenderer.isShowLabels();
            boolean showGridY = this.mRenderer.isShowGridY();
            DateFormat format = this.getDateFormat(xLabels.get(0), xLabels.get(length - 1));
            int i = 0;
            while (i < length) {
                long label = Math.round(xLabels.get(i));
                float xLabel = (float)((double)left + xPixelsPerUnit * ((double)label - minX));
                if (showLabels) {
                    paint.setColor(this.mRenderer.getXLabelsColor());
                    canvas.drawLine(xLabel, (float)bottom, xLabel, (float)bottom + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                    this.drawText(canvas, format.format(new Date(label)), xLabel, (float)bottom + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f, paint, this.mRenderer.getXLabelsAngle());
                }
                if (showGridY) {
                    paint.setColor(this.mRenderer.getGridColor());
                    canvas.drawLine(xLabel, (float)bottom, xLabel, (float)top, paint);
                }
                ++i;
            }
        }
        this.drawXTextLabels(xTextLabelLocations, canvas, paint, true, left, top, bottom, xPixelsPerUnit, minX, maxX);
    }

    private DateFormat getDateFormat(double start, double end) {
        DateFormat format;
        if (this.mDateFormat != null) {
            format = null;
            try {
                format = new SimpleDateFormat(this.mDateFormat);
                return format;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        format = SimpleDateFormat.getDateInstance(2);
        double diff = end - start;
        if (diff > 8.64E7 && diff < 4.32E8) {
            format = SimpleDateFormat.getDateTimeInstance(3, 3);
        } else if (diff < 8.64E7) {
            format = SimpleDateFormat.getTimeInstance(2);
        }
        return format;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected List<Double> getXLabels(double min, double max, int count) {
        block16: {
            result = new ArrayList<Double>();
            if (!this.mRenderer.isXRoundedLabels()) {
                if (this.mDataset.getSeriesCount() > 0) {
                    series = this.mDataset.getSeriesAt(0);
                    length = series.getItemCount();
                    intervalLength = 0;
                    startIndex = -1;
                    i = 0;
                    while (i < length) {
                        value = series.getX(i);
                        if (min <= value && value <= max) {
                            ++intervalLength;
                            if (startIndex < 0) {
                                startIndex = i;
                            }
                        }
                        ++i;
                    }
                    if (intervalLength < count) {
                        i = startIndex;
                        while (i < startIndex + intervalLength) {
                            result.add(series.getX(i));
                            ++i;
                        }
                    } else {
                        step = (float)intervalLength / (float)count;
                        intervalCount = 0;
                        i = 0;
                        while (i < length && intervalCount < count) {
                            value = series.getX(Math.round((float)i * step));
                            if (min <= value && value <= max) {
                                result.add(value);
                                ++intervalCount;
                            }
                            ++i;
                        }
                    }
                    return result;
                }
                return super.getXLabels(min, max, count);
            }
            if (this.mStartPoint == null) {
                this.mStartPoint = min - min % 8.64E7 + 8.64E7 + (double)(new Date(Math.round(min)).getTimezoneOffset() * 60 * 1000);
            }
            if (count > 25) {
                count = 25;
            }
            if ((cycleMath = (max - min) / (double)count) <= 0.0) {
                return result;
            }
            cycle = 8.64E7;
            if (!(cycleMath <= 8.64E7)) ** GOTO lbl51
            while (cycleMath < cycle / 2.0) {
                cycle /= 2.0;
            }
            break block16;
lbl-1000:
            // 1 sources

            {
                cycle *= 2.0;
lbl51:
                // 2 sources

                ** while (cycleMath > cycle)
            }
        }
        val = this.mStartPoint - Math.floor((this.mStartPoint - min) / cycle) * cycle;
        i = 0;
        while (val < max && i++ <= count) {
            result.add(val);
            val += cycle;
        }
        return result;
    }
}

