/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import com.ab.view.chart.ClickableArea;
import com.ab.view.chart.SimpleSeriesRenderer;
import com.ab.view.chart.XYChart;
import com.ab.view.chart.XYMultipleSeriesDataset;
import com.ab.view.chart.XYMultipleSeriesRenderer;
import com.ab.view.chart.XYSeriesRenderer;

public class ScatterChart
extends XYChart {
    public static final String TYPE = "Scatter";
    private static final float SIZE = 3.0f;
    private static final int SHAPE_WIDTH = 10;
    private float size = 3.0f;

    ScatterChart() {
    }

    public ScatterChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
        Log.d((String)"ScatterChart", (String)"\u8c03\u7528\u7236\u7c7bXYChart\u7684XYMultipleSeriesDataset \u8bbe\u7f6e2");
        this.size = renderer.getPointSize();
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super.setDatasetRenderer(dataset, renderer);
        this.size = renderer.getPointSize();
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] points, int[] colors, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, int startIndex) {
        XYSeriesRenderer renderer = (XYSeriesRenderer)seriesRenderer;
        paint.setColor(renderer.getColor());
        if (renderer.isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStyle(Paint.Style.STROKE);
        }
        int length = points.length;
        switch (renderer.getPointStyle()) {
            case X: {
                int i = 0;
                while (i < length) {
                    this.drawX(canvas, paint, points[i], points[i + 1]);
                    i += 2;
                }
                break;
            }
            case CIRCLE: {
                int i = 0;
                while (i < length) {
                    if (colors != null && colors[i / 2] != 0) {
                        paint.setColor(colors[i / 2]);
                    }
                    this.drawCircle(canvas, paint, points[i], points[i + 1]);
                    paint.setColor(renderer.getColor());
                    i += 2;
                }
                break;
            }
            case TRIANGLE: {
                float[] path = new float[6];
                int i = 0;
                while (i < length) {
                    this.drawTriangle(canvas, paint, path, points[i], points[i + 1]);
                    i += 2;
                }
                break;
            }
            case SQUARE: {
                int i = 0;
                while (i < length) {
                    this.drawSquare(canvas, paint, points[i], points[i + 1]);
                    i += 2;
                }
                break;
            }
            case DIAMOND: {
                float[] path = new float[8];
                int i = 0;
                while (i < length) {
                    this.drawDiamond(canvas, paint, path, points[i], points[i + 1]);
                    i += 2;
                }
                break;
            }
            case POINT: {
                canvas.drawPoints(points, paint);
            }
        }
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(float[] points, double[] values, float yAxisValue, int seriesIndex, int startIndex) {
        int length = points.length;
        ClickableArea[] ret = new ClickableArea[length / 2];
        int i = 0;
        while (i < length) {
            int selectableBuffer = this.mRenderer.getSelectableBuffer();
            ret[i / 2] = new ClickableArea(new RectF(points[i] - (float)selectableBuffer, points[i + 1] - (float)selectableBuffer, points[i] + (float)selectableBuffer, points[i + 1] + (float)selectableBuffer), values[i], values[i + 1]);
            i += 2;
        }
        return ret;
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        if (((XYSeriesRenderer)renderer).isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStyle(Paint.Style.STROKE);
        }
        switch (((XYSeriesRenderer)renderer).getPointStyle()) {
            case X: {
                this.drawX(canvas, paint, x + 10.0f, y);
                break;
            }
            case CIRCLE: {
                this.drawCircle(canvas, paint, x + 10.0f, y);
                break;
            }
            case TRIANGLE: {
                this.drawTriangle(canvas, paint, new float[6], x + 10.0f, y);
                break;
            }
            case SQUARE: {
                this.drawSquare(canvas, paint, x + 10.0f, y);
                break;
            }
            case DIAMOND: {
                this.drawDiamond(canvas, paint, new float[8], x + 10.0f, y);
                break;
            }
            case POINT: {
                canvas.drawPoint(x + 10.0f, y, paint);
            }
        }
    }

    private void drawX(Canvas canvas, Paint paint, float x, float y) {
        canvas.drawLine(x - this.size, y - this.size, x + this.size, y + this.size, paint);
        canvas.drawLine(x + this.size, y - this.size, x - this.size, y + this.size, paint);
    }

    private void drawCircle(Canvas canvas, Paint paint, float x, float y) {
        canvas.drawCircle(x, y, this.size, paint);
    }

    private void drawTriangle(Canvas canvas, Paint paint, float[] path, float x, float y) {
        path[0] = x;
        path[1] = y - this.size - this.size / 2.0f;
        path[2] = x - this.size;
        path[3] = y + this.size;
        path[4] = x + this.size;
        path[5] = path[3];
        this.drawPath(canvas, path, paint, true);
    }

    private void drawSquare(Canvas canvas, Paint paint, float x, float y) {
        canvas.drawRect(x - this.size, y - this.size, x + this.size, y + this.size, paint);
    }

    private void drawDiamond(Canvas canvas, Paint paint, float[] path, float x, float y) {
        path[0] = x;
        path[1] = y - this.size;
        path[2] = x - this.size;
        path[3] = y;
        path[4] = x;
        path[5] = y + this.size;
        path[6] = x + this.size;
        path[7] = y;
        this.drawPath(canvas, path, paint, true);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

