/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.app;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.animation.Animation;
import android.view.animation.Transformation;

public class AbRotate3dAnimation2
extends Animation {
    private float mFromDegree;
    private float mToDegree;
    private float mCenterX;
    private float mCenterY;
    private float mLeft;
    private float mTop;
    private Camera mCamera;
    private static final String TAG = "Rotate3d";

    public AbRotate3dAnimation2(float fromDegree, float toDegree, float left, float top, float centerX, float centerY) {
        this.mFromDegree = fromDegree;
        this.mToDegree = toDegree;
        this.mLeft = left;
        this.mTop = top;
        this.mCenterX = centerX;
        this.mCenterY = centerY;
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mCamera = new Camera();
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        float FromDegree = this.mFromDegree;
        float degrees = FromDegree + (this.mToDegree - this.mFromDegree) * interpolatedTime;
        float centerX = this.mCenterX;
        float centerY = this.mCenterY;
        Matrix matrix = t.getMatrix();
        if (degrees <= -76.0f) {
            degrees = -90.0f;
            this.mCamera.save();
            this.mCamera.rotateY(degrees);
            this.mCamera.getMatrix(matrix);
            this.mCamera.restore();
        } else if (degrees >= 76.0f) {
            degrees = 90.0f;
            this.mCamera.save();
            this.mCamera.rotateY(degrees);
            this.mCamera.getMatrix(matrix);
            this.mCamera.restore();
        } else {
            this.mCamera.save();
            this.mCamera.translate(0.0f, 0.0f, centerX);
            this.mCamera.rotateY(degrees);
            this.mCamera.translate(0.0f, 0.0f, -centerX);
            this.mCamera.getMatrix(matrix);
            this.mCamera.restore();
        }
        matrix.preTranslate(-centerX, -centerY);
        matrix.postTranslate(centerX, centerY);
    }
}

