/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.app;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.view.View;
import com.ab.util.AbStrUtil;
import java.util.List;
import java.util.TimeZone;

public class AbNumberClock
extends View {
    private Time mCalendar;
    private Drawable mTimeBg;
    private Drawable mTimeColon;
    private List<Drawable> dTimeBmp;
    private List<Drawable> dApmBmp;
    private int mTimeBgWidth;
    private int mTimeBgHeight;
    private boolean mAttached;
    private final Handler mHandler = new Handler();
    private String mMinutes;
    private String mHour;
    private String mSecond;
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED")) {
                String tz = intent.getStringExtra("time-zone");
                AbNumberClock.this.mCalendar = new Time(TimeZone.getTimeZone(tz).getID());
            }
        }
    };

    public AbNumberClock(Context context, Drawable timeBg, Drawable timeColon, List<Drawable> timeBmp, List<Drawable> apmBmp) {
        super(context);
        this.mTimeBg = timeBg;
        this.mTimeColon = timeColon;
        this.dTimeBmp = timeBmp;
        this.dApmBmp = apmBmp;
        this.mCalendar = new Time();
        if (!this.dApmBmp.isEmpty() && this.dApmBmp.size() > 0) {
            this.mTimeBgWidth = 2 * this.mTimeColon.getIntrinsicWidth() + 6 * this.dTimeBmp.get(0).getIntrinsicWidth() + this.dApmBmp.get(0).getIntrinsicWidth();
            this.mTimeBgHeight = this.dTimeBmp.get(0).getIntrinsicHeight();
        } else {
            this.mTimeBgWidth = 2 * this.mTimeColon.getIntrinsicWidth() + 8 * this.dTimeBmp.get(0).getIntrinsicWidth();
            this.mTimeBgHeight = this.dTimeBmp.get(0).getIntrinsicHeight();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mAttached) {
            this.mAttached = true;
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mHandler);
        }
        this.mCalendar = new Time();
        this.onTimeChanged();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAttached) {
            this.getContext().unregisterReceiver(this.mIntentReceiver);
            this.mAttached = false;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float hScale = 1.0f;
        float vScale = 1.0f;
        if (widthMode != 0 && widthSize < this.mTimeBgWidth) {
            hScale = (float)widthSize / (float)this.mTimeBgWidth;
        }
        if (heightMode != 0 && heightSize < this.mTimeBgHeight) {
            vScale = (float)heightSize / (float)this.mTimeBgHeight;
        }
        float scale = Math.min(hScale, vScale);
        this.setMeasuredDimension(this.mTimeBgWidth * (int)scale, this.mTimeBgHeight * (int)scale);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int availableWidth = this.getRight() - this.getLeft();
        int availableHeight = this.getBottom() - this.getTop();
        int x = availableWidth / 2;
        int y = availableHeight / 2;
        int w = 0;
        int h = 0;
        if (!this.dApmBmp.isEmpty() && this.dApmBmp.size() > 0) {
            w = 2 * this.mTimeColon.getIntrinsicWidth() + 8 * this.dTimeBmp.get(0).getIntrinsicWidth() + this.dApmBmp.get(0).getIntrinsicWidth();
            h = this.dTimeBmp.get(0).getIntrinsicHeight();
        } else {
            w = 2 * this.mTimeColon.getIntrinsicWidth() + 6 * this.dTimeBmp.get(0).getIntrinsicWidth();
            h = this.dTimeBmp.get(0).getIntrinsicHeight();
        }
        boolean scaled = false;
        if (availableWidth < w || availableHeight < h) {
            scaled = true;
            float scale = Math.min((float)availableWidth / (float)w, (float)availableHeight / (float)h);
            canvas.save();
            canvas.scale(scale, scale, (float)x, (float)y);
        }
        int dis_x = x - w / 2;
        int dis_y = y - h / 2;
        if (this.mTimeBg != null) {
            Drawable timeBg = this.mTimeBg;
            timeBg.setBounds(dis_x, dis_y, dis_x + w, dis_y + h);
            timeBg.draw(canvas);
            canvas.save();
        }
        int pos = Integer.parseInt(this.mHour.substring(0, 1));
        Drawable timeBmp = this.dTimeBmp.get(pos);
        int numW = timeBmp.getIntrinsicWidth();
        int numH = timeBmp.getIntrinsicHeight();
        timeBmp.setBounds(dis_x, dis_y, dis_x + numW, dis_y + numH);
        timeBmp.draw(canvas);
        pos = Integer.parseInt(this.mHour.substring(1, 2));
        timeBmp = this.dTimeBmp.get(pos);
        timeBmp.setBounds(dis_x + numW, dis_y, dis_x + 2 * numW, dis_y + numH);
        timeBmp.draw(canvas);
        Drawable timeColon = this.mTimeColon;
        int colonW = timeColon.getIntrinsicWidth();
        int colonH = timeColon.getIntrinsicHeight();
        if (colonH < numH) {
            timeColon.setBounds(dis_x + 2 * numW, dis_y + (numH - colonH) / 2, dis_x + 2 * numW + colonW, dis_y + (numH - colonH) / 2 + colonH);
        } else {
            timeColon.setBounds(dis_x + 2 * numW, dis_y, dis_x + 2 * numW + colonW, dis_y + colonH);
        }
        timeColon.draw(canvas);
        pos = Integer.parseInt(this.mMinutes.substring(0, 1));
        timeBmp = this.dTimeBmp.get(pos);
        timeBmp.setBounds(dis_x + 2 * numW + colonW, dis_y, dis_x + 3 * numW + colonW, dis_y + numH);
        timeBmp.draw(canvas);
        pos = Integer.parseInt(this.mMinutes.substring(1, 2));
        timeBmp = this.dTimeBmp.get(pos);
        timeBmp.setBounds(dis_x + 3 * numW + colonW, dis_y, dis_x + 4 * numW + colonW, dis_y + numH);
        timeBmp.draw(canvas);
        if (colonH < numH) {
            timeColon.setBounds(dis_x + 4 * numW + colonW, dis_y + (numH - colonH) / 2, dis_x + 4 * numW + 2 * colonW, dis_y + (numH - colonH) / 2 + colonH);
        } else {
            timeColon.setBounds(dis_x + 4 * numW + colonW, dis_y, dis_x + 4 * numW + 2 * colonW, dis_y + colonH);
        }
        timeColon.draw(canvas);
        pos = Integer.parseInt(this.mSecond.substring(0, 1));
        timeBmp = this.dTimeBmp.get(pos);
        timeBmp.setBounds(dis_x + 4 * numW + 2 * colonW, dis_y, dis_x + 5 * numW + 2 * colonW, dis_y + numH);
        timeBmp.draw(canvas);
        pos = Integer.parseInt(this.mSecond.substring(1, 2));
        timeBmp = this.dTimeBmp.get(pos);
        timeBmp.setBounds(dis_x + 5 * numW + 2 * colonW, dis_y, dis_x + 6 * numW + 2 * colonW, dis_y + numH);
        timeBmp.draw(canvas);
        if (!this.dApmBmp.isEmpty() && this.dApmBmp.size() > 0 && !this.get24HourMode()) {
            pos = this.mCalendar.hour > 12 ? 1 : 0;
            timeBmp = this.dApmBmp.get(pos);
            int apmW = timeBmp.getIntrinsicWidth();
            int apmH = timeBmp.getIntrinsicHeight();
            if (apmH < numH) {
                timeBmp.setBounds(dis_x + 4 * numW + colonW, dis_y + (numH - apmH) / 2, dis_x + 4 * numW + colonW + apmW, dis_y + (numH - apmH) / 2 + apmH);
            } else {
                timeBmp.setBounds(dis_x + 4 * numW + colonW, dis_y, dis_x + 4 * numW + colonW + apmW, dis_y + apmH);
            }
            timeBmp.draw(canvas);
        }
        if (scaled) {
            canvas.restore();
        }
    }

    private boolean get24HourMode() {
        return DateFormat.is24HourFormat((Context)this.getContext());
    }

    private void onTimeChanged() {
        this.mCalendar.setToNow();
        this.mHour = !this.get24HourMode() && !this.dApmBmp.isEmpty() && this.dApmBmp.size() > 0 ? (this.mCalendar.hour > 12 ? String.format("%02d", this.mCalendar.hour - 12) : String.format("%02d", this.mCalendar.hour)) : String.format("%02d", this.mCalendar.hour);
        this.mSecond = AbStrUtil.strFormat2(String.valueOf(this.mCalendar.second));
        this.mMinutes = String.format("%02d", this.mCalendar.minute);
        this.updateContentDescription(this.mCalendar);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                AbNumberClock.this.onTimeChanged();
            }
        }, 1000L);
        this.invalidate();
    }

    private void updateContentDescription(Time time) {
        int flags = 129;
        String contentDescription = DateUtils.formatDateTime((Context)this.getContext(), (long)time.toMillis(false), (int)flags);
        this.setContentDescription(contentDescription);
    }
}

