/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.app;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public class AbCompassView
extends ImageView {
    private Context mContext = null;
    private Drawable mCompassDrawable = null;
    private float mDirection = 0.0f;

    public AbCompassView(Context context) {
        this(context, null);
    }

    public AbCompassView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawColor(0);
        int h = this.getHeight();
        int w = this.getWidth();
        canvas.rotate(-(90.0f + this.mDirection), (float)(w / 2), (float)(h / 2));
        super.onDraw(canvas);
    }

    public float getDirection() {
        return this.mDirection;
    }

    public void setDirection(float direction) {
        this.mDirection = direction;
        this.invalidate();
    }

    public void setCompassDrawable(Drawable drawable) {
        this.mCompassDrawable = drawable;
        this.mCompassDrawable.setBounds(0, 0, this.mCompassDrawable.getIntrinsicWidth(), this.mCompassDrawable.getIntrinsicHeight());
        this.setImageDrawable(this.mCompassDrawable);
        this.invalidate();
    }

    public void setCompassDrawable(int id) {
        this.mCompassDrawable = this.mContext.getResources().getDrawable(id);
        this.mCompassDrawable.setBounds(0, 0, this.mCompassDrawable.getIntrinsicWidth(), this.mCompassDrawable.getIntrinsicHeight());
        this.setImageDrawable(this.mCompassDrawable);
        this.invalidate();
    }
}

