/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.app;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.view.View;
import com.ab.util.AbLogUtil;
import java.util.TimeZone;

public class AbAnalogClock
extends View {
    private Time mCalendar;
    private Drawable mHourHand;
    private Drawable mMinuteHand;
    private Drawable mSecondHand;
    private Drawable mDial;
    private int mDialWidth;
    private int mDialHeight;
    private boolean mAttached;
    private float mMinutes;
    private float mHour;
    private float mSecond;
    private final Handler mHandler = new Handler();
    private boolean mChanged;
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED")) {
                String tz = intent.getStringExtra("time-zone");
                AbAnalogClock.this.mCalendar = new Time(TimeZone.getTimeZone(tz).getID());
            }
        }
    };

    public AbAnalogClock(Context context, Drawable dial, Drawable hourHand, Drawable minuteHand, Drawable secondHand) {
        super(context);
        this.mDial = dial;
        this.mHourHand = hourHand;
        this.mMinuteHand = minuteHand;
        this.mSecondHand = secondHand;
        this.mCalendar = new Time();
        this.mDialWidth = this.mDial.getIntrinsicWidth();
        this.mDialHeight = this.mDial.getIntrinsicHeight();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mAttached) {
            this.mAttached = true;
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mHandler);
        }
        this.mCalendar = new Time();
        this.onTimeChanged();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAttached) {
            this.getContext().unregisterReceiver(this.mIntentReceiver);
            this.mAttached = false;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float hScale = 1.0f;
        float vScale = 1.0f;
        if (widthMode != 0 && widthSize < this.mDialWidth) {
            hScale = (float)widthSize / (float)this.mDialWidth;
        }
        if (heightMode != 0 && heightSize < this.mDialHeight) {
            vScale = (float)heightSize / (float)this.mDialHeight;
        }
        float scale = Math.min(hScale, vScale);
        this.setMeasuredDimension(this.mDialWidth * (int)scale, this.mDialHeight * (int)scale);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mChanged = true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        boolean changed = this.mChanged;
        if (changed) {
            this.mChanged = false;
        }
        int availableWidth = this.getRight() - this.getLeft();
        int availableHeight = this.getBottom() - this.getTop();
        int x = availableWidth / 2;
        int y = availableHeight / 2;
        Drawable dial = this.mDial;
        int w = dial.getIntrinsicWidth();
        int h = dial.getIntrinsicHeight();
        boolean scaled = false;
        if (availableWidth < w || availableHeight < h) {
            scaled = true;
            float scale = Math.min((float)availableWidth / (float)w, (float)availableHeight / (float)h);
            canvas.save();
            canvas.scale(scale, scale, (float)x, (float)y);
        }
        if (changed) {
            dial.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
        }
        dial.draw(canvas);
        canvas.save();
        canvas.rotate(this.mHour / 12.0f * 360.0f, (float)x, (float)y);
        Drawable hourHand = this.mHourHand;
        if (changed) {
            w = hourHand.getIntrinsicWidth();
            h = hourHand.getIntrinsicHeight();
            hourHand.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
        }
        hourHand.draw(canvas);
        canvas.restore();
        canvas.save();
        canvas.rotate(this.mMinutes / 60.0f * 360.0f, (float)x, (float)y);
        Drawable minuteHand = this.mMinuteHand;
        if (changed) {
            w = minuteHand.getIntrinsicWidth();
            h = minuteHand.getIntrinsicHeight();
            minuteHand.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
        }
        minuteHand.draw(canvas);
        canvas.restore();
        canvas.save();
        canvas.rotate(this.mSecond / 60.0f * 360.0f, (float)x, (float)y);
        Drawable secondHand = this.mSecondHand;
        if (changed) {
            w = secondHand.getIntrinsicWidth();
            h = secondHand.getIntrinsicHeight();
            secondHand.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
        }
        secondHand.draw(canvas);
        canvas.restore();
        if (scaled) {
            canvas.restore();
        }
    }

    private void onTimeChanged() {
        this.mCalendar.setToNow();
        int hour = this.mCalendar.hour;
        int minute = this.mCalendar.minute;
        int second = this.mCalendar.second;
        this.mSecond = second;
        this.mMinutes = (float)minute + (float)second / 60.0f;
        this.mHour = (float)hour + this.mMinutes / 60.0f;
        this.mChanged = true;
        AbLogUtil.d(AbAnalogClock.class, "\u65f6\u95f4\u6539\u53d8:mHour:" + this.mHour + ",mMinutes:" + this.mMinutes + ",mSecond:" + this.mSecond);
        this.updateContentDescription(this.mCalendar);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                AbAnalogClock.this.onTimeChanged();
            }
        }, 1000L);
        this.invalidate();
    }

    private void updateContentDescription(Time time) {
        int flags = 129;
        String contentDescription = DateUtils.formatDateTime((Context)this.getContext(), (long)time.toMillis(false), (int)129);
        this.setContentDescription(contentDescription);
    }
}

