/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import android.content.Context;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.ab.global.AbAppConfig;
import com.ab.util.AbAppUtil;
import com.ab.util.AbLogUtil;

public class AbViewUtil {
    public static final int INVALID = Integer.MIN_VALUE;

    public static void setAbsListViewHeight(AbsListView absListView, int lineNumber, int verticalSpace) {
        int totalHeight = AbViewUtil.getAbsListViewHeight(absListView, lineNumber, verticalSpace);
        ViewGroup.LayoutParams params = absListView.getLayoutParams();
        params.height = totalHeight;
        ((ViewGroup.MarginLayoutParams)params).setMargins(0, 0, 0, 0);
        absListView.setLayoutParams(params);
    }

    public static int getAbsListViewHeight(AbsListView absListView, int lineNumber, int verticalSpace) {
        int totalHeight = 0;
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        absListView.measure(w, h);
        ListAdapter mListAdapter = (ListAdapter)absListView.getAdapter();
        if (mListAdapter == null) {
            return totalHeight;
        }
        int count = mListAdapter.getCount();
        if (absListView instanceof ListView) {
            int i = 0;
            while (i < count) {
                View listItem = mListAdapter.getView(i, null, (ViewGroup)absListView);
                listItem.measure(w, h);
                totalHeight += listItem.getMeasuredHeight();
                ++i;
            }
            totalHeight = count == 0 ? verticalSpace : (totalHeight += ((ListView)absListView).getDividerHeight() * (count - 1));
        } else if (absListView instanceof GridView) {
            int remain = count % lineNumber;
            if (remain > 0) {
                remain = 1;
            }
            if (mListAdapter.getCount() == 0) {
                totalHeight = verticalSpace;
            } else {
                View listItem = mListAdapter.getView(0, null, (ViewGroup)absListView);
                listItem.measure(w, h);
                int line = count / lineNumber + remain;
                totalHeight = line * listItem.getMeasuredHeight() + (line - 1) * verticalSpace;
            }
        }
        return totalHeight;
    }

    public static void measureView(View view) {
        ViewGroup.LayoutParams p = view.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)p.width);
        int lpHeight = p.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(childWidthSpec, childHeightSpec);
    }

    public static int getViewWidth(View view) {
        AbViewUtil.measureView(view);
        return view.getMeasuredWidth();
    }

    public static int getViewHeight(View view) {
        AbViewUtil.measureView(view);
        return view.getMeasuredHeight();
    }

    public static void removeSelfFromParent(View v) {
        ViewParent parent = v.getParent();
        if (parent != null && parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView(v);
        }
    }

    public static float dip2px(Context context, float dipValue) {
        DisplayMetrics mDisplayMetrics = AbAppUtil.getDisplayMetrics(context);
        return AbViewUtil.applyDimension(1, dipValue, mDisplayMetrics);
    }

    public static float px2dip(Context context, float pxValue) {
        DisplayMetrics mDisplayMetrics = AbAppUtil.getDisplayMetrics(context);
        return pxValue / mDisplayMetrics.density;
    }

    public static float sp2px(Context context, float spValue) {
        DisplayMetrics mDisplayMetrics = AbAppUtil.getDisplayMetrics(context);
        return AbViewUtil.applyDimension(2, spValue, mDisplayMetrics);
    }

    public static float px2sp(Context context, float pxValue) {
        DisplayMetrics mDisplayMetrics = AbAppUtil.getDisplayMetrics(context);
        return pxValue / mDisplayMetrics.scaledDensity;
    }

    public static int scale(Context context, float value) {
        DisplayMetrics mDisplayMetrics = AbAppUtil.getDisplayMetrics(context);
        return AbViewUtil.scale(mDisplayMetrics.widthPixels, mDisplayMetrics.heightPixels, value);
    }

    public static int scale(int displayWidth, int displayHeight, float pxValue) {
        if (pxValue == 0.0f) {
            return 0;
        }
        float scale = 1.0f;
        try {
            float scaleWidth = (float)displayWidth / (float)AbAppConfig.UI_WIDTH;
            float scaleHeight = (float)displayHeight / (float)AbAppConfig.UI_HEIGHT;
            scale = Math.min(scaleWidth, scaleHeight);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Math.round(pxValue * scale + 0.5f);
    }

    public static float applyDimension(int unit, float value, DisplayMetrics metrics) {
        switch (unit) {
            case 0: {
                return value;
            }
            case 1: {
                return value * metrics.density;
            }
            case 2: {
                return value * metrics.scaledDensity;
            }
            case 3: {
                return value * metrics.xdpi * 0.013888889f;
            }
            case 4: {
                return value * metrics.xdpi;
            }
            case 5: {
                return value * metrics.xdpi * 0.03937008f;
            }
        }
        return 0.0f;
    }

    public static void scaleContentView(ViewGroup contentView) {
        AbViewUtil.scaleView((View)contentView);
        if (contentView.getChildCount() > 0) {
            int i = 0;
            while (i < contentView.getChildCount()) {
                if (contentView.getChildAt(i) instanceof ViewGroup) {
                    AbViewUtil.scaleContentView((ViewGroup)contentView.getChildAt(i));
                } else {
                    AbViewUtil.scaleView(contentView.getChildAt(i));
                }
                ++i;
            }
        }
    }

    public static void scaleView(View view) {
        ViewGroup.MarginLayoutParams mMarginLayoutParams;
        ViewGroup.LayoutParams params;
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            AbViewUtil.setTextSize(textView, textView.getTextSize());
        }
        if ((params = view.getLayoutParams()) != null) {
            int width = Integer.MIN_VALUE;
            int height = Integer.MIN_VALUE;
            if (params.width != -2 && params.width != -1) {
                width = params.width;
            }
            if (params.height != -2 && params.height != -1) {
                height = params.height;
            }
            AbViewUtil.setViewSize(view, width, height);
            AbViewUtil.setPadding(view, view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom());
        }
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams && (mMarginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams()) != null) {
            AbViewUtil.setMargin(view, mMarginLayoutParams.leftMargin, mMarginLayoutParams.topMargin, mMarginLayoutParams.rightMargin, mMarginLayoutParams.bottomMargin);
        }
    }

    public static void setSPTextSize(TextView textView, float size) {
        float scaledSize = AbViewUtil.scale(textView.getContext(), size);
        textView.setTextSize(scaledSize);
    }

    public static void setTextSize(TextView textView, float sizePixels) {
        float scaledSize = AbViewUtil.scale(textView.getContext(), sizePixels);
        textView.setTextSize(0, scaledSize);
    }

    public static void setTextSize(Context context, TextPaint textPaint, float sizePixels) {
        float scaledSize = AbViewUtil.scale(context, sizePixels);
        textPaint.setTextSize(scaledSize);
    }

    public static void setTextSize(Context context, Paint paint, float sizePixels) {
        float scaledSize = AbViewUtil.scale(context, sizePixels);
        paint.setTextSize(scaledSize);
    }

    public static void setViewSize(View view, int widthPixels, int heightPixels) {
        int scaledWidth = AbViewUtil.scale(view.getContext(), widthPixels);
        int scaledHeight = AbViewUtil.scale(view.getContext(), heightPixels);
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (params == null) {
            AbLogUtil.e(AbViewUtil.class, "setViewSize\u51fa\u9519,\u5982\u679c\u662f\u4ee3\u7801new\u51fa\u6765\u7684View\uff0c\u9700\u8981\u8bbe\u7f6e\u4e00\u4e2a\u9002\u5408\u7684LayoutParams");
            return;
        }
        if (widthPixels != Integer.MIN_VALUE) {
            params.width = scaledWidth;
        }
        if (heightPixels != Integer.MIN_VALUE) {
            params.height = scaledHeight;
        }
        view.setLayoutParams(params);
    }

    public static void setPadding(View view, int left, int top, int right, int bottom) {
        int scaledLeft = AbViewUtil.scale(view.getContext(), left);
        int scaledTop = AbViewUtil.scale(view.getContext(), top);
        int scaledRight = AbViewUtil.scale(view.getContext(), right);
        int scaledBottom = AbViewUtil.scale(view.getContext(), bottom);
        view.setPadding(scaledLeft, scaledTop, scaledRight, scaledBottom);
    }

    public static void setMargin(View view, int left, int top, int right, int bottom) {
        ViewGroup.MarginLayoutParams mMarginLayoutParams;
        int scaledLeft = AbViewUtil.scale(view.getContext(), left);
        int scaledTop = AbViewUtil.scale(view.getContext(), top);
        int scaledRight = AbViewUtil.scale(view.getContext(), right);
        int scaledBottom = AbViewUtil.scale(view.getContext(), bottom);
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams && (mMarginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams()) != null) {
            if (left != Integer.MIN_VALUE) {
                mMarginLayoutParams.leftMargin = scaledLeft;
            }
            if (right != Integer.MIN_VALUE) {
                mMarginLayoutParams.rightMargin = scaledRight;
            }
            if (top != Integer.MIN_VALUE) {
                mMarginLayoutParams.topMargin = scaledTop;
            }
            if (bottom != Integer.MIN_VALUE) {
                mMarginLayoutParams.bottomMargin = scaledBottom;
            }
            view.setLayoutParams((ViewGroup.LayoutParams)mMarginLayoutParams);
        }
    }
}

