/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AbStrUtil {
    public static String parseEmpty(String str) {
        if (str == null || "null".equals(str.trim())) {
            str = "";
        }
        return str.trim();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static int chineseLength(String str) {
        int valueLength = 0;
        String chinese = "[\u0391-\uffe5]";
        if (!AbStrUtil.isEmpty(str)) {
            int i = 0;
            while (i < str.length()) {
                String temp = str.substring(i, i + 1);
                if (temp.matches(chinese)) {
                    valueLength += 2;
                }
                ++i;
            }
        }
        return valueLength;
    }

    public static int strLength(String str) {
        int valueLength = 0;
        String chinese = "[\u0391-\uffe5]";
        if (!AbStrUtil.isEmpty(str)) {
            int i = 0;
            while (i < str.length()) {
                String temp = str.substring(i, i + 1);
                valueLength = temp.matches(chinese) ? (valueLength += 2) : ++valueLength;
                ++i;
            }
        }
        return valueLength;
    }

    public static int subStringLength(String str, int maxL) {
        int currentIndex = 0;
        int valueLength = 0;
        String chinese = "[\u0391-\uffe5]";
        int i = 0;
        while (i < str.length()) {
            String temp = str.substring(i, i + 1);
            valueLength = temp.matches(chinese) ? (valueLength += 2) : ++valueLength;
            if (valueLength >= maxL) {
                currentIndex = i;
                break;
            }
            ++i;
        }
        return currentIndex;
    }

    public static Boolean isMobileNo(String str) {
        Boolean isMobileNo = false;
        try {
            Pattern p = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$");
            Matcher m = p.matcher(str);
            isMobileNo = m.matches();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isMobileNo;
    }

    public static Boolean isNumberLetter(String str) {
        Boolean isNoLetter = false;
        String expr = "^[A-Za-z0-9]+$";
        if (str.matches(expr)) {
            isNoLetter = true;
        }
        return isNoLetter;
    }

    public static Boolean isNumber(String str) {
        Boolean isNumber = false;
        String expr = "^[0-9]+$";
        if (str.matches(expr)) {
            isNumber = true;
        }
        return isNumber;
    }

    public static Boolean isEmail(String str) {
        Boolean isEmail = false;
        String expr = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        if (str.matches(expr)) {
            isEmail = true;
        }
        return isEmail;
    }

    public static Boolean isChinese(String str) {
        Boolean isChinese = true;
        String chinese = "[\u0391-\uffe5]";
        if (!AbStrUtil.isEmpty(str)) {
            int i = 0;
            while (i < str.length()) {
                String temp = str.substring(i, i + 1);
                if (!temp.matches(chinese)) {
                    isChinese = false;
                }
                ++i;
            }
        }
        return isChinese;
    }

    public static Boolean isContainChinese(String str) {
        Boolean isChinese = false;
        String chinese = "[\u0391-\uffe5]";
        if (!AbStrUtil.isEmpty(str)) {
            int i = 0;
            while (i < str.length()) {
                String temp = str.substring(i, i + 1);
                if (temp.matches(chinese)) {
                    isChinese = true;
                }
                ++i;
            }
        }
        return isChinese;
    }

    public static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block13: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuilder();
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                    if (sb.indexOf("\n") != -1 && sb.lastIndexOf("\n") == sb.length() - 1) {
                        sb.delete(sb.lastIndexOf("\n"), sb.lastIndexOf("\n") + 1);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static String dateTimeFormat(String dateTime) {
        StringBuilder sb;
        block12: {
            block11: {
                sb = new StringBuilder();
                if (!AbStrUtil.isEmpty(dateTime)) break block11;
                return null;
            }
            try {
                String[] dateAndTime = dateTime.split(" ");
                if (dateAndTime.length <= 0) break block12;
                String[] stringArray = dateAndTime;
                int n = dateAndTime.length;
                int n2 = 0;
                while (n2 < n) {
                    String str1;
                    int i;
                    String[] date;
                    String str = stringArray[n2];
                    if (str.indexOf("-") != -1) {
                        date = str.split("-");
                        i = 0;
                        while (i < date.length) {
                            str1 = date[i];
                            sb.append(AbStrUtil.strFormat2(str1));
                            if (i < date.length - 1) {
                                sb.append("-");
                            }
                            ++i;
                        }
                    } else if (str.indexOf(":") != -1) {
                        sb.append(" ");
                        date = str.split(":");
                        i = 0;
                        while (i < date.length) {
                            str1 = date[i];
                            sb.append(AbStrUtil.strFormat2(str1));
                            if (i < date.length - 1) {
                                sb.append(":");
                            }
                            ++i;
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return sb.toString();
    }

    public static String strFormat2(String str) {
        try {
            if (str.length() <= 1) {
                str = "0" + str;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public static String cutString(String str, int length) {
        return AbStrUtil.cutString(str, length, "");
    }

    public static String cutString(String str, int length, String dot) {
        char[] ch;
        int strBLen = AbStrUtil.strlen(str, "GBK");
        if (strBLen <= length) {
            return str;
        }
        int temp = 0;
        StringBuffer sb = new StringBuffer(length);
        char[] cArray = ch = str.toCharArray();
        int n = ch.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            sb.append(c);
            temp = c > '\u0100' ? (temp += 2) : ++temp;
            if (temp >= length) {
                if (dot == null) break;
                sb.append(dot);
                break;
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String cutStringFromChar(String str1, String str2, int offset) {
        if (AbStrUtil.isEmpty(str1)) {
            return "";
        }
        int start = str1.indexOf(str2);
        if (start != -1 && str1.length() > start + offset) {
            return str1.substring(start + offset);
        }
        return "";
    }

    public static int strlen(String str, String charset) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int length = 0;
        try {
            length = str.getBytes(charset).length;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return length;
    }

    public static String getSizeDesc(long size) {
        String suffix = "B";
        if (size >= 1024L) {
            suffix = "K";
            if ((size >>= 10) >= 1024L) {
                suffix = "M";
                if ((size >>= 10) >= 1024L) {
                    suffix = "G";
                    size >>= 10;
                }
            }
        }
        return String.valueOf(size) + suffix;
    }

    public static long ip2int(String ip) {
        ip = ip.replace(".", ",");
        String[] items = ip.split(",");
        return Long.valueOf(items[0]) << 24 | Long.valueOf(items[1]) << 16 | Long.valueOf(items[2]) << 8 | Long.valueOf(items[3]);
    }

    public static void main(String[] args) {
        System.out.println(AbStrUtil.dateTimeFormat("2012-3-2 12:2:20"));
    }
}

