/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.ab.util.AbAppUtil;
import com.ab.util.AbViewUtil;
import com.ab.view.app.AbMonitorView;

public final class AbMonitorUtil {
    public static boolean mMonitorOpened = false;
    private static AbMonitorView mAbMonitorView = null;
    private static Handler mMonitorHandler = new Handler();
    private static Runnable mMonitorRunnable = null;
    private static WindowManager mWindowManager = null;
    private static WindowManager.LayoutParams mMonitorParams = null;

    public static void openMonitor(Context context) {
        if (mMonitorOpened) {
            return;
        }
        mWindowManager = ((Activity)context).getWindowManager();
        DisplayMetrics display = AbAppUtil.getDisplayMetrics(context);
        final int diaplayWidth = display.widthPixels;
        mAbMonitorView = new AbMonitorView(context);
        mMonitorParams = new WindowManager.LayoutParams();
        AbMonitorUtil.mMonitorParams.type = 2002;
        AbMonitorUtil.mMonitorParams.format = 1;
        AbMonitorUtil.mMonitorParams.flags = 40;
        AbMonitorUtil.mMonitorParams.width = AbViewUtil.scale(context, 100.0f);
        AbMonitorUtil.mMonitorParams.height = AbViewUtil.scale(context, 50.0f);
        mWindowManager.addView((View)mAbMonitorView, (ViewGroup.LayoutParams)mMonitorParams);
        mMonitorOpened = true;
        mMonitorRunnable = new Runnable(){

            @Override
            public void run() {
                mAbMonitorView.postInvalidate();
                mMonitorHandler.postDelayed((Runnable)this, 0L);
            }
        };
        mMonitorHandler.postDelayed(mMonitorRunnable, 0L);
        mAbMonitorView.setOnTouchListener(new View.OnTouchListener(){
            int lastX;
            int lastY;
            int paramX;
            int paramY;

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        this.lastX = (int)event.getRawX();
                        this.lastY = (int)event.getRawY();
                        this.paramX = mMonitorParams.x;
                        this.paramY = mMonitorParams.y;
                        break;
                    }
                    case 2: {
                        int dx = (int)event.getRawX() - this.lastX;
                        int dy = (int)event.getRawY() - this.lastY;
                        mMonitorParams.x = this.paramX + dx > diaplayWidth / 2 ? diaplayWidth : 0;
                        mMonitorParams.x = this.paramX + dx;
                        mMonitorParams.y = this.paramY + dy;
                        mWindowManager.updateViewLayout((View)mAbMonitorView, (ViewGroup.LayoutParams)mMonitorParams);
                    }
                }
                return true;
            }
        });
    }

    public static void closeMonitor() {
        if (mMonitorOpened) {
            if (mWindowManager != null && mAbMonitorView != null) {
                mWindowManager.removeView((View)mAbMonitorView);
            }
            mMonitorOpened = false;
            if (mMonitorHandler != null && mMonitorRunnable != null) {
                mMonitorHandler.removeCallbacks(mMonitorRunnable);
            }
        }
    }
}

