/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.inputmethod.InputMethodManager;
import com.ab.model.AbAppProcessInfo;
import com.ab.model.AbCPUInfo;
import com.ab.model.AbProcessInfo;
import com.ab.model.AbPsRow;
import com.ab.util.AbLogUtil;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class AbAppUtil {
    public static List<String[]> mProcessList = null;

    public static void installApk(Context context, File file) {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
        context.startActivity(intent);
    }

    public static void uninstallApk(Context context, String packageName) {
        Intent intent = new Intent("android.intent.action.DELETE");
        Uri packageURI = Uri.parse((String)("package:" + packageName));
        intent.setData(packageURI);
        context.startActivity(intent);
    }

    public static boolean isServiceRunning(Context context, String className) {
        boolean isRunning = false;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List servicesList = activityManager.getRunningServices(Integer.MAX_VALUE);
        for (ActivityManager.RunningServiceInfo si : servicesList) {
            if (!className.equals(si.service.getClassName())) continue;
            isRunning = true;
        }
        return isRunning;
    }

    public static boolean stopRunningService(Context context, String className) {
        Intent intent_service = null;
        boolean ret = false;
        try {
            intent_service = new Intent(context, Class.forName(className));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (intent_service != null) {
            ret = context.stopService(intent_service);
        }
        return ret;
    }

    public static int getNumCores() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches("cpu[0-9]", pathname.getName());
                }
            });
            return files.length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            NetworkInfo info;
            ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
            return connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isGpsEnabled(Context context) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        return lm.isProviderEnabled("gps");
    }

    public static boolean isMobile(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 0;
    }

    public static boolean importDatabase(Context context, String dbName, int rawRes) {
        boolean flag;
        block23: {
            int buffer_size = 1024;
            InputStream is = null;
            FileOutputStream fos = null;
            flag = false;
            try {
                try {
                    String dbPath = "/data/data/" + context.getPackageName() + "/databases/" + dbName;
                    File dbfile = new File(dbPath);
                    if (!dbfile.exists()) {
                        if (!dbfile.getParentFile().exists()) {
                            dbfile.getParentFile().mkdirs();
                        }
                        dbfile.createNewFile();
                        is = context.getResources().openRawResource(rawRes);
                        fos = new FileOutputStream(dbfile);
                        byte[] buffer = new byte[buffer_size];
                        int count = 0;
                        while ((count = is.read(buffer)) > 0) {
                            fos.write(buffer, 0, count);
                        }
                        fos.flush();
                    }
                    flag = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (is == null) break block23;
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return flag;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        Resources mResources = context == null ? Resources.getSystem() : context.getResources();
        DisplayMetrics mDisplayMetrics = mResources.getDisplayMetrics();
        return mDisplayMetrics;
    }

    public static void showSoftInput(Context context) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        inputMethodManager.toggleSoftInput(0, 2);
    }

    public static void closeSoftInput(Context context) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        if (inputMethodManager != null && ((Activity)context).getCurrentFocus() != null) {
            inputMethodManager.hideSoftInputFromWindow(((Activity)context).getCurrentFocus().getWindowToken(), 2);
        }
    }

    public static PackageInfo getPackageInfo(Context context) {
        PackageInfo info = null;
        try {
            String packageName = context.getPackageName();
            info = context.getPackageManager().getPackageInfo(packageName, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }

    public static List<AbAppProcessInfo> getRunningAppProcesses(Context context) {
        ActivityManager activityManager = null;
        ArrayList<AbAppProcessInfo> list = null;
        PackageManager packageManager = null;
        try {
            activityManager = (ActivityManager)context.getSystemService("activity");
            packageManager = context.getApplicationContext().getPackageManager();
            list = new ArrayList<AbAppProcessInfo>();
            List appProcessList = activityManager.getRunningAppProcesses();
            ApplicationInfo appInfo = null;
            AbAppProcessInfo abAppProcessInfo = null;
            PackageInfo packageInfo = AbAppUtil.getPackageInfo(context);
            if (mProcessList != null) {
                mProcessList.clear();
            }
            mProcessList = AbAppUtil.getProcessRunningInfo();
            for (ActivityManager.RunningAppProcessInfo appProcessInfo : appProcessList) {
                Drawable icon;
                abAppProcessInfo = new AbAppProcessInfo(appProcessInfo.processName, appProcessInfo.pid, appProcessInfo.uid);
                appInfo = AbAppUtil.getApplicationInfo(context, appProcessInfo.processName);
                if (appInfo != null) {
                    icon = appInfo.loadIcon(packageManager);
                    String appName = appInfo.loadLabel(packageManager).toString();
                    abAppProcessInfo.icon = icon;
                    abAppProcessInfo.appName = appName;
                } else {
                    if (appProcessInfo.processName.indexOf(":") != -1) {
                        appInfo = AbAppUtil.getApplicationInfo(context, appProcessInfo.processName.split(":")[0]);
                        abAppProcessInfo.icon = icon = appInfo.loadIcon(packageManager);
                    }
                    abAppProcessInfo.appName = appProcessInfo.processName;
                }
                AbProcessInfo processInfo = AbAppUtil.getMemInfo(appProcessInfo.processName);
                abAppProcessInfo.memory = processInfo.memory;
                abAppProcessInfo.cpu = processInfo.cpu;
                abAppProcessInfo.status = processInfo.status;
                abAppProcessInfo.threadsCount = processInfo.threadsCount;
                list.add(abAppProcessInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ApplicationInfo getApplicationInfo(Context context, String processName) {
        if (processName == null) {
            return null;
        }
        PackageManager packageManager = context.getApplicationContext().getPackageManager();
        List appList = packageManager.getInstalledApplications(8192);
        for (ApplicationInfo appInfo : appList) {
            if (!processName.equals(appInfo.processName)) continue;
            return appInfo;
        }
        return null;
    }

    public static void killProcesses(Context context, int pid, String processName) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        String packageName = null;
        try {
            packageName = processName.indexOf(":") == -1 ? processName : processName.split(":")[0];
            activityManager.killBackgroundProcesses(packageName);
            Method forceStopPackage = activityManager.getClass().getDeclaredMethod("forceStopPackage", String.class);
            forceStopPackage.setAccessible(true);
            forceStopPackage.invoke((Object)activityManager, packageName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<AbPsRow> ps() {
        ArrayList<AbPsRow> psRowlist = new ArrayList<AbPsRow>();
        String ps = AbAppUtil.runScript("ps");
        String[] lines = ps.split("\n");
        psRowlist = new ArrayList();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            AbPsRow row = new AbPsRow(line);
            if (row.pid != null) {
                psRowlist.add(row);
            }
            ++n2;
        }
        return psRowlist;
    }

    public static AbPsRow getPsRow(String processName) {
        List<AbPsRow> psRowlist = AbAppUtil.ps();
        for (AbPsRow row : psRowlist) {
            if (!processName.equals(row.cmd)) continue;
            return row;
        }
        return null;
    }

    public static AbProcessInfo getMemInfo(String processName) {
        AbProcessInfo process = new AbProcessInfo();
        if (mProcessList == null) {
            mProcessList = AbAppUtil.getProcessRunningInfo();
        }
        String processNameTemp = "";
        for (String[] item : mProcessList) {
            processNameTemp = item[9];
            if (processNameTemp == null || !processNameTemp.equals(processName)) continue;
            process.pid = Integer.parseInt(item[0]);
            process.cpu = item[2];
            process.status = item[3];
            process.threadsCount = item[4];
            long mem = 0L;
            if (item[6].indexOf("M") != -1) {
                mem = Long.parseLong(item[6].replace("M", "")) * 1000L * 1024L;
            } else if (item[6].indexOf("K") != -1) {
                mem = Long.parseLong(item[6].replace("K", "")) * 1000L;
            } else if (item[6].indexOf("G") != -1) {
                mem = Long.parseLong(item[6].replace("G", "")) * 1000L * 1024L * 1024L;
            }
            process.memory = mem;
            process.uid = item[8];
            process.processName = item[9];
            break;
        }
        if (process.memory == 0L) {
            AbLogUtil.d(AbAppUtil.class, "##" + processName + ",top -n 1\u672a\u627e\u5230");
        }
        return process;
    }

    public static AbProcessInfo getMemInfo(int pid) {
        AbProcessInfo process = new AbProcessInfo();
        if (mProcessList == null) {
            mProcessList = AbAppUtil.getProcessRunningInfo();
        }
        String tempPidString = "";
        int tempPid = 0;
        int count = mProcessList.size();
        int i = 0;
        while (i < count) {
            String[] item = mProcessList.get(i);
            tempPidString = item[0];
            if (tempPidString != null && (tempPid = Integer.parseInt(tempPidString)) == pid) {
                process.pid = Integer.parseInt(item[0]);
                process.cpu = item[2];
                process.status = item[3];
                process.threadsCount = item[4];
                long mem = 0L;
                if (item[6].indexOf("M") != -1) {
                    mem = Long.parseLong(item[6].replace("M", "")) * 1000L * 1024L;
                } else if (item[6].indexOf("K") != -1) {
                    mem = Long.parseLong(item[6].replace("K", "")) * 1000L;
                } else if (item[6].indexOf("G") != -1) {
                    mem = Long.parseLong(item[6].replace("G", "")) * 1000L * 1024L * 1024L;
                }
                process.memory = mem;
                process.uid = item[8];
                process.processName = item[9];
                break;
            }
            ++i;
        }
        return process;
    }

    public static String runCommand(String[] command, String workdirectory) {
        String result = "";
        AbLogUtil.d(AbAppUtil.class, "#" + command);
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            if (workdirectory != null) {
                builder.directory(new File(workdirectory));
            }
            builder.redirectErrorStream(true);
            Process process = builder.start();
            InputStream in = process.getInputStream();
            byte[] buffer = new byte[1024];
            while (in.read(buffer) != -1) {
                String str = new String(buffer);
                result = String.valueOf(result) + str;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String runScript(String script) {
        String sRet = "";
        try {
            final Process m_process = Runtime.getRuntime().exec(script);
            final StringBuilder sbread = new StringBuilder();
            Thread tout = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(m_process.getInputStream()), 8192);
                    String ls_1 = null;
                    try {
                        try {
                            while ((ls_1 = bufferedReader.readLine()) != null) {
                                sbread.append(ls_1).append("\n");
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    finally {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            tout.start();
            final StringBuilder sberr = new StringBuilder();
            Thread terr = new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(m_process.getErrorStream()), 8192);
                    String ls_1 = null;
                    try {
                        try {
                            while ((ls_1 = bufferedReader.readLine()) != null) {
                                sberr.append(ls_1).append("\n");
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    finally {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            terr.start();
            int retvalue = m_process.waitFor();
            while (tout.isAlive()) {
                Thread.sleep(50L);
            }
            if (terr.isAlive()) {
                terr.interrupt();
            }
            String stdout = sbread.toString();
            String stderr = sberr.toString();
            sRet = String.valueOf(stdout) + stderr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return sRet;
    }

    public static boolean getRootPermission(Context context) {
        String packageCodePath = context.getPackageCodePath();
        Process process = null;
        FilterOutputStream os = null;
        try {
            try {
                String cmd = "chmod 777 " + packageCodePath;
                process = Runtime.getRuntime().exec("su");
                os = new DataOutputStream(process.getOutputStream());
                ((DataOutputStream)os).writeBytes(String.valueOf(cmd) + "\n");
                ((DataOutputStream)os).writeBytes("exit\n");
                ((DataOutputStream)os).flush();
                process.waitFor();
            }
            catch (Exception e) {
                try {
                    if (os != null) {
                        os.close();
                    }
                    process.destroy();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return false;
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                process.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static List<String[]> getProcessRunningInfo() {
        List<String[]> processList = null;
        try {
            String result = AbAppUtil.runCommandTopN1();
            processList = AbAppUtil.parseProcessRunningInfo(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processList;
    }

    public static String runCommandTopN1() {
        String result = null;
        try {
            String[] args = new String[]{"/system/bin/top", "-n", "1"};
            result = AbAppUtil.runCommand(args, "/system/bin/");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static AbCPUInfo getCPUInfo() {
        AbCPUInfo CPUInfo = null;
        try {
            String result = AbAppUtil.runCommandTopN1();
            CPUInfo = AbAppUtil.parseCPUInfo(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CPUInfo;
    }

    public static List<String[]> parseProcessRunningInfo(String info) {
        ArrayList<String[]> processList = new ArrayList<String[]>();
        int Length_ProcStat = 10;
        String tempString = "";
        boolean bIsProcInfo = false;
        String[] rows = null;
        String[] columns = null;
        rows = info.split("[\n]+");
        int i = 0;
        while (i < rows.length) {
            tempString = rows[i];
            if (tempString.indexOf("PID") == -1) {
                if (bIsProcInfo && (columns = (tempString = tempString.trim()).split("[ ]+")).length == Length_ProcStat && !columns[9].startsWith("/system/bin/")) {
                    processList.add(columns);
                }
            } else {
                bIsProcInfo = true;
            }
            ++i;
        }
        return processList;
    }

    public static AbCPUInfo parseCPUInfo(String info) {
        AbCPUInfo CPUInfo = new AbCPUInfo();
        String tempString = "";
        String[] rows = null;
        String[] columns = null;
        rows = info.split("[\n]+");
        int i = 0;
        while (i < rows.length) {
            tempString = rows[i];
            if (tempString.indexOf("User") != -1 && tempString.indexOf("System") != -1) {
                tempString = tempString.trim();
                columns = tempString.split(",");
                int j = 0;
                while (j < columns.length) {
                    String col = columns[j].trim();
                    String[] cpu = col.split(" ");
                    if (j == 0) {
                        CPUInfo.User = cpu[1];
                    } else if (j == 1) {
                        CPUInfo.System = cpu[1];
                    } else if (j == 2) {
                        CPUInfo.IOW = cpu[1];
                    } else if (j == 3) {
                        CPUInfo.IRQ = cpu[1];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return CPUInfo;
    }

    public static long getAvailMemory(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo.availMem;
    }

    public static long getTotalMemory(Context context) {
        String file = "/proc/meminfo";
        long memory = 0L;
        try {
            String[] strs;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader, 8192);
            String memInfo = bufferedReader.readLine();
            String[] stringArray = strs = memInfo.split("\\s+");
            int n = strs.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                AbLogUtil.d(AbAppUtil.class, String.valueOf(str) + "\t");
                ++n2;
            }
            memory = Integer.valueOf(strs[1]) * 1024;
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return memory;
    }
}

