/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;

public class AbAnimationUtil {
    public static final long aniDurationMillis = 1L;

    public static void largerView(View view, float scale) {
        if (view == null) {
            return;
        }
        view.bringToFront();
        int width = view.getWidth();
        float animationSize = 1.0f + scale / (float)width;
        AbAnimationUtil.scaleView(view, animationSize);
    }

    public static void restoreLargerView(View view, float scale) {
        if (view == null) {
            return;
        }
        int width = view.getWidth();
        float toSize = 1.0f + scale / (float)width;
        AbAnimationUtil.scaleView(view, -1.0f * toSize);
    }

    private static void scaleView(View view, float toSize) {
        ScaleAnimation scale = null;
        if (toSize == 0.0f) {
            return;
        }
        scale = toSize > 0.0f ? new ScaleAnimation(1.0f, toSize, 1.0f, toSize, 1, 0.5f, 1, 0.5f) : new ScaleAnimation(toSize * -1.0f, 1.0f, toSize * -1.0f, 1.0f, 1, 0.5f, 1, 0.5f);
        scale.setDuration(1L);
        scale.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        scale.setFillAfter(true);
        view.startAnimation((Animation)scale);
    }

    private void playJumpAnimation(final View view, final float offsetY) {
        float originalY = 0.0f;
        float finalY = -offsetY;
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.addAnimation((Animation)new TranslateAnimation(0.0f, 0.0f, originalY, finalY));
        animationSet.setDuration(300L);
        animationSet.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        animationSet.setFillAfter(true);
        animationSet.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                AbAnimationUtil.this.playLandAnimation(view, offsetY);
            }
        });
        view.startAnimation((Animation)animationSet);
    }

    private void playLandAnimation(final View view, final float offsetY) {
        float originalY = -offsetY;
        float finalY = 0.0f;
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.addAnimation((Animation)new TranslateAnimation(0.0f, 0.0f, originalY, finalY));
        animationSet.setDuration(200L);
        animationSet.setInterpolator((Interpolator)new AccelerateInterpolator());
        animationSet.setFillAfter(true);
        animationSet.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        AbAnimationUtil.this.playJumpAnimation(view, offsetY);
                    }
                }, 2000L);
            }
        });
        view.startAnimation((Animation)animationSet);
    }

    public static void playRotateAnimation(View v, long durationMillis, int repeatCount, int repeatMode) {
        AnimationSet animationSet = new AnimationSet(true);
        RotateAnimation rotateAnimation = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        rotateAnimation.setDuration(durationMillis);
        rotateAnimation.setRepeatCount(repeatCount);
        rotateAnimation.setRepeatMode(repeatMode);
        rotateAnimation.setInterpolator(v.getContext(), 17432582);
        animationSet.addAnimation((Animation)rotateAnimation);
        v.startAnimation((Animation)animationSet);
    }
}

