/*
 * Decompiled with CFR 0.152.
 */
package com.ab.task;

import android.os.Handler;
import android.os.Message;
import com.ab.task.AbTaskItem;
import com.ab.task.AbTaskListListener;
import com.ab.task.AbTaskObjectListener;
import com.ab.task.AbThreadFactory;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;

public class AbTaskPool {
    private static AbTaskPool abTaskPool = null;
    public static Executor mExecutorService = null;
    private static HashMap<String, Object> result;
    private static Handler handler;

    static {
        handler = new Handler(){

            public void handleMessage(Message msg) {
                AbTaskItem item = (AbTaskItem)msg.obj;
                if (item.getListener() instanceof AbTaskListListener) {
                    ((AbTaskListListener)item.getListener()).update((List)result.get(item.toString()));
                } else if (item.getListener() instanceof AbTaskObjectListener) {
                    ((AbTaskObjectListener)item.getListener()).update(result.get(item.toString()));
                } else {
                    item.getListener().update();
                }
                result.remove(item.toString());
            }
        };
    }

    protected AbTaskPool() {
        result = new HashMap();
        mExecutorService = AbThreadFactory.getExecutorService();
    }

    public static AbTaskPool getInstance() {
        if (abTaskPool == null) {
            abTaskPool = new AbTaskPool();
        }
        return abTaskPool;
    }

    public void execute(final AbTaskItem item) {
        mExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (item.getListener() != null) {
                        if (item.getListener() instanceof AbTaskListListener) {
                            result.put(item.toString(), ((AbTaskListListener)item.getListener()).getList());
                        } else if (item.getListener() instanceof AbTaskObjectListener) {
                            result.put(item.toString(), ((AbTaskObjectListener)item.getListener()).getObject());
                        } else {
                            item.getListener().get();
                            result.put(item.toString(), null);
                        }
                        Message msg = handler.obtainMessage();
                        msg.obj = item;
                        handler.sendMessage(msg);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

