/*
 * Decompiled with CFR 0.152.
 */
package com.ab.soap;

import android.os.Handler;
import android.os.Message;

public abstract class AbSoapListener {
    private Handler mHandler = new SoapResponderHandler(this);
    protected static final int SUCCESS_MESSAGE = 0;
    protected static final int FAILURE_MESSAGE = 1;
    protected static final int START_MESSAGE = 4;
    protected static final int FINISH_MESSAGE = 5;
    protected static final int PROGRESS_MESSAGE = 6;

    public abstract void onSuccess(int var1, String var2);

    public abstract void onFailure(int var1, String var2, Throwable var3);

    public void onStart() {
    }

    public void onFinish() {
    }

    public void sendStartMessage() {
        this.sendMessage(this.obtainMessage(4, null));
    }

    public void sendFinishMessage() {
        this.sendMessage(this.obtainMessage(5, null));
    }

    public void sendFailureMessage(int statusCode, String content, Throwable error) {
        this.sendMessage(this.obtainMessage(1, new Object[]{statusCode, content, error}));
    }

    public void sendSuccessMessage(int statusCode, String content) {
        this.sendMessage(this.obtainMessage(0, new Object[]{statusCode, content}));
    }

    public void sendMessage(Message msg) {
        if (msg != null) {
            msg.sendToTarget();
        }
    }

    protected Message obtainMessage(int responseMessage, Object response) {
        Message msg;
        if (this.mHandler != null) {
            msg = this.mHandler.obtainMessage(responseMessage, response);
        } else {
            msg = Message.obtain();
            if (msg != null) {
                msg.what = responseMessage;
                msg.obj = response;
            }
        }
        return msg;
    }

    private class SoapResponderHandler
    extends Handler {
        private Object[] content;
        private AbSoapListener listener;

        public SoapResponderHandler(AbSoapListener listener) {
            this.listener = listener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 4: {
                    this.listener.onStart();
                    break;
                }
                case 1: {
                    this.content = (Object[])msg.obj;
                    this.listener.onFailure((Integer)this.content[0], (String)this.content[1], (Throwable)this.content[2]);
                    break;
                }
                case 0: {
                    this.content = (Object[])msg.obj;
                    if (this.content.length < 2) break;
                    this.listener.onSuccess((Integer)this.content[0], (String)this.content[1]);
                    break;
                }
                case 5: {
                    this.listener.onFinish();
                    break;
                }
            }
        }
    }
}

