/*
 * Decompiled with CFR 0.152.
 */
package com.ab.network.toolbox;

import com.ab.network.toolbox.Cache;
import com.ab.network.toolbox.VolleyError;

public class Response<T> {
    public final T result;
    public final Cache.Entry cacheEntry;
    public final VolleyError error;
    public boolean intermediate = false;

    public static <T> Response<T> success(T result, Cache.Entry cacheEntry) {
        return new Response<T>(result, cacheEntry);
    }

    public static <T> Response<T> error(VolleyError error) {
        return new Response<T>(error);
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    private Response(T result, Cache.Entry cacheEntry) {
        this.result = result;
        this.cacheEntry = cacheEntry;
        this.error = null;
    }

    private Response(VolleyError error) {
        this.result = null;
        this.cacheEntry = null;
        this.error = error;
    }

    public static interface ErrorListener {
        public void onErrorResponse(VolleyError var1);
    }

    public static interface Listener<T> {
        public void onResponse(T var1);
    }
}

