/*
 * Decompiled with CFR 0.152.
 */
package com.ab.network.toolbox;

import com.ab.network.toolbox.Cache;
import com.ab.network.toolbox.NetworkResponse;
import java.util.Map;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;

public class HttpHeaderParser {
    public static Cache.Entry parseCacheHeaders(NetworkResponse response) {
        return HttpHeaderParser.parseCacheHeaders(response, 1000L);
    }

    public static Cache.Entry parseCacheHeaders(NetworkResponse response, long expiresTime) {
        long now = System.currentTimeMillis();
        Map<String, String> headers = response.headers;
        long serverDate = 0L;
        long serverExpires = 0L;
        long softExpire = 0L;
        long maxAge = 0L;
        boolean hasCacheControl = false;
        String serverEtag = null;
        String headerValue = headers.get("Date");
        if (headerValue != null) {
            serverDate = HttpHeaderParser.parseDateAsEpoch(headerValue);
        }
        if ((headerValue = headers.get("Cache-Control")) != null) {
            hasCacheControl = true;
            String[] tokens = headerValue.split(",");
            int i = 0;
            while (i < tokens.length) {
                String token = tokens[i].trim();
                if (token.equals("no-cache") || token.equals("no-store")) {
                    return null;
                }
                if (token.startsWith("max-age=")) {
                    try {
                        maxAge = Long.parseLong(token.substring(8));
                    }
                    catch (Exception exception) {}
                } else if (token.equals("must-revalidate") || token.equals("proxy-revalidate")) {
                    maxAge = 0L;
                }
                ++i;
            }
        }
        serverExpires = (headerValue = headers.get("Expires")) != null ? HttpHeaderParser.parseDateAsEpoch(headerValue) : System.currentTimeMillis() + expiresTime;
        serverEtag = headers.get("ETag");
        if (hasCacheControl) {
            softExpire = now + maxAge * 1000L;
        } else if (serverDate > 0L && serverExpires >= serverDate) {
            softExpire = now + (serverExpires - serverDate);
        }
        Cache.Entry entry = new Cache.Entry();
        entry.data = response.data;
        entry.etag = serverEtag;
        entry.ttl = entry.softTtl = softExpire;
        entry.serverDate = serverDate;
        entry.responseHeaders = headers;
        return entry;
    }

    public static long parseDateAsEpoch(String dateStr) {
        try {
            return DateUtils.parseDate((String)dateStr).getTime();
        }
        catch (DateParseException e) {
            return 0L;
        }
    }

    public static String parseCharset(Map<String, String> headers) {
        String contentType = headers.get("Content-Type");
        if (contentType != null) {
            String[] params = contentType.split(";");
            int i = 1;
            while (i < params.length) {
                String[] pair = params[i].trim().split("=");
                if (pair.length == 2 && pair[0].equals("charset")) {
                    return pair[1];
                }
                ++i;
            }
        }
        return "ISO-8859-1";
    }
}

