/*
 * Decompiled with CFR 0.152.
 */
package com.ab.model;

public class AbPsRow {
    public String pid;
    public String cmd;
    public String ppid;
    public String user;
    public int mem;
    public String rootPid;

    public AbPsRow(String line) {
        if (line == null) {
            return;
        }
        String[] p = line.split("[\\s]+");
        if (p.length != 9) {
            return;
        }
        this.user = p[0];
        this.pid = p[1];
        this.ppid = p[2];
        this.mem = Integer.parseInt(p[4]);
        this.cmd = p[8];
        if (this.isRoot()) {
            this.rootPid = this.pid;
        }
    }

    public boolean isRoot() {
        return "zygote".equals(this.cmd);
    }

    public boolean isMain() {
        return this.ppid.equals(this.rootPid) && this.user.startsWith("app_");
    }

    public String toString() {
        String TAB = ";";
        String retValue = "";
        retValue = "PsRow ( " + super.toString() + ";" + "pid = " + this.pid + ";" + "cmd = " + this.cmd + ";" + "ppid = " + this.ppid + ";" + "user = " + this.user + ";" + "mem = " + this.mem + " )";
        return retValue;
    }
}

