/*
 * Decompiled with CFR 0.152.
 */
package com.ab.image;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.util.LruCache;
import com.ab.image.toolbox.ImageLoader;

@TargetApi(value=12)
public class AbImageCache
implements ImageLoader.ImageCache {
    private static LruCache<String, Bitmap> mCache;
    private static AbImageCache mImageCache;

    public AbImageCache() {
        int maxSize = 0xA00000;
        mCache = new LruCache<String, Bitmap>(maxSize){

            protected int sizeOf(String key, Bitmap value) {
                return value.getRowBytes() * value.getHeight();
            }
        };
    }

    public static AbImageCache getInstance() {
        if (mImageCache == null) {
            mImageCache = new AbImageCache();
        }
        return mImageCache;
    }

    @Override
    public Bitmap getBitmap(String url) {
        return (Bitmap)mCache.get((Object)url);
    }

    @Override
    public void putBitmap(String url, Bitmap bitmap) {
        mCache.put((Object)url, (Object)bitmap);
    }

    public void clearBitmap() {
        mCache.evictAll();
    }
}

