/*
 * Decompiled with CFR 0.152.
 */
package com.ab.http;

import android.util.Log;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class AuthSSLX509TrustManager
implements X509TrustManager {
    private X509TrustManager defaultTrustManager = null;
    private static final String TAG = "AuthSSLX509TrustManager";

    public AuthSSLX509TrustManager(X509TrustManager defaultTrustManager) {
        if (defaultTrustManager == null) {
            throw new IllegalArgumentException("Trust manager may not be null");
        }
        this.defaultTrustManager = defaultTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null) {
            int c = 0;
            while (c < certificates.length) {
                X509Certificate cert = certificates[c];
                Log.i((String)TAG, (String)("  Client certificate " + (c + 1) + ":"));
                Log.i((String)TAG, (String)("  Subject DN: " + cert.getSubjectDN()));
                Log.i((String)TAG, (String)("  Signature Algorithm: " + cert.getSigAlgName()));
                Log.i((String)TAG, (String)("  Valid from: " + cert.getNotBefore()));
                Log.i((String)TAG, (String)("  Valid until: " + cert.getNotAfter()));
                Log.i((String)TAG, (String)("  Issuer: " + cert.getIssuerDN()));
                ++c;
            }
        }
        this.defaultTrustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null) {
            int c = 0;
            while (c < certificates.length) {
                X509Certificate cert = certificates[c];
                Log.i((String)TAG, (String)("  Server certificate " + (c + 1) + ":"));
                Log.i((String)TAG, (String)("  Subject DN: " + cert.getSubjectDN()));
                Log.i((String)TAG, (String)("  Signature Algorithm: " + cert.getSigAlgName()));
                Log.i((String)TAG, (String)("  Valid from: " + cert.getNotBefore()));
                Log.i((String)TAG, (String)("  Valid until: " + cert.getNotAfter()));
                Log.i((String)TAG, (String)("  Issuer: " + cert.getIssuerDN()));
                ++c;
            }
        }
        this.defaultTrustManager.checkServerTrusted(certificates, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }
}

