/*
 * Decompiled with CFR 0.152.
 */
package com.ab.http;

import com.ab.http.AbHttpResponseListener;
import com.ab.http.AbMultipartEntity;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class AbRequestParams {
    protected ConcurrentHashMap<String, String> urlParams;
    protected ConcurrentHashMap<String, FileWrapper> fileParams;
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";

    public AbRequestParams() {
        this.init();
    }

    public AbRequestParams(Map<String, String> source) {
        this.init();
        for (Map.Entry<String, String> entry : source.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public AbRequestParams(String key, String value) {
        this.init();
        this.put(key, value);
    }

    private void init() {
        this.urlParams = new ConcurrentHashMap();
        this.fileParams = new ConcurrentHashMap();
    }

    public void put(String key, String value) {
        if (key != null && value != null) {
            this.urlParams.put(key, value);
        }
    }

    public void put(String key, File file, String contentType) {
        if (key != null && file != null) {
            this.fileParams.put(key, new FileWrapper(file, contentType));
        }
    }

    public void put(String key, File file) {
        this.put(key, file, APPLICATION_OCTET_STREAM);
    }

    public void remove(String key) {
        this.urlParams.remove(key);
        this.fileParams.remove(key);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey());
            result.append("=");
            result.append(entry.getValue());
        }
        return result.toString();
    }

    public List<BasicNameValuePair> getParamsList() {
        LinkedList<BasicNameValuePair> paramsList = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            paramsList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return paramsList;
    }

    public String getParamString() {
        return URLEncodedUtils.format(this.getParamsList(), (String)"UTF-8");
    }

    public HttpEntity getEntity(AbHttpResponseListener responseListener) throws IOException {
        if (this.fileParams.isEmpty()) {
            return this.createFormEntity();
        }
        return this.createMultipartEntity(responseListener);
    }

    public HttpEntity createFormEntity() {
        try {
            return new UrlEncodedFormEntity(this.getParamsList(), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private HttpEntity createMultipartEntity(AbHttpResponseListener responseListener) throws IOException {
        AbMultipartEntity entity = new AbMultipartEntity(responseListener);
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            entity.addPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.fileParams.entrySet()) {
            FileWrapper fileWrapper = (FileWrapper)entry.getValue();
            entity.addPart(entry.getKey(), fileWrapper.file, fileWrapper.contentType);
        }
        return entity;
    }

    public ConcurrentHashMap<String, String> getUrlParams() {
        return this.urlParams;
    }

    public void setUrlParams(ConcurrentHashMap<String, String> urlParams) {
        this.urlParams = urlParams;
    }

    private static class FileWrapper {
        public File file;
        public String contentType;

        public FileWrapper(File file, String contentType) {
            this.file = file;
            this.contentType = contentType;
        }
    }
}

