/*
 * Decompiled with CFR 0.152.
 */
package com.ab.http;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.ab.global.AbAppConfig;
import com.ab.global.AbAppException;
import com.ab.http.AbBinaryHttpResponseListener;
import com.ab.http.AbFileHttpResponseListener;
import com.ab.http.AbGzipDecompressingEntity;
import com.ab.http.AbHttpResponseListener;
import com.ab.http.AbRequestParams;
import com.ab.http.AbStringHttpResponseListener;
import com.ab.http.EasySSLProtocolSocketFactory;
import com.ab.task.AbThreadFactory;
import com.ab.util.AbAppUtil;
import com.ab.util.AbFileUtil;
import com.ab.util.AbLogUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class AbHttpClient {
    private static Context mContext;
    public static Executor mExecutorService;
    private String encode = "UTF-8";
    private String userAgent = "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.43 BIDUBrowser/6.x Safari/537.31";
    private static final String HTTP_GET = "GET";
    private static final String HTTP_POST = "POST";
    private static final String USER_AGENT = "User-Agent";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final int DEFAULT_MAX_CONNECTIONS = 10;
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;
    private static final int BUFFER_SIZE = 4096;
    protected static final int SUCCESS_MESSAGE = 0;
    protected static final int FAILURE_MESSAGE = 1;
    protected static final int FAILURE_MESSAGE_CONNECT = 2;
    protected static final int FAILURE_MESSAGE_SERVICE = 3;
    protected static final int START_MESSAGE = 4;
    protected static final int FINISH_MESSAGE = 5;
    protected static final int PROGRESS_MESSAGE = 6;
    protected static final int RETRY_MESSAGE = 7;
    private int mTimeout = 10000;
    private boolean mIsOpenEasySSL = true;
    private DefaultHttpClient mHttpClient = null;
    private HttpContext mHttpContext = null;
    private HttpRequestRetryHandler mRequestRetryHandler = new HttpRequestRetryHandler(){

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (executionCount >= 3) {
                AbLogUtil.d(mContext, "\u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570\uff0c\u4e0d\u91cd\u8bd5");
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                AbLogUtil.d(mContext, "\u670d\u52a1\u5668\u4e22\u6389\u4e86\u8fde\u63a5\uff0c\u91cd\u8bd5");
                return true;
            }
            if (exception instanceof SSLHandshakeException) {
                AbLogUtil.d(mContext, "ssl \u5f02\u5e38 \u4e0d\u91cd\u8bd5");
                return false;
            }
            HttpRequest request = (HttpRequest)context.getAttribute("http.request");
            boolean idempotent = request instanceof HttpEntityEnclosingRequest;
            if (!idempotent) {
                AbLogUtil.d(mContext, "\u8bf7\u6c42\u88ab\u8ba4\u4e3a\u662f\u5e42\u7b49\u7684\uff0c\u91cd\u8bd5");
                return true;
            }
            return exception != null;
        }
    };

    static {
        mExecutorService = null;
    }

    public AbHttpClient(Context context) {
        mContext = context;
        mExecutorService = AbThreadFactory.getExecutorService();
        this.mHttpContext = new BasicHttpContext();
    }

    public void get(final String url, final AbRequestParams params, final AbHttpResponseListener responseListener) {
        responseListener.setHandler(new ResponderHandler(responseListener));
        mExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AbHttpClient.this.doGet(url, params, responseListener);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void post(final String url, final AbRequestParams params, final AbHttpResponseListener responseListener) {
        responseListener.setHandler(new ResponderHandler(responseListener));
        mExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AbHttpClient.this.doPost(url, params, responseListener);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void doGet(String url, AbRequestParams params, AbHttpResponseListener responseListener) {
        try {
            responseListener.sendStartMessage();
            if (!AbAppUtil.isNetworkAvailable(mContext)) {
                responseListener.sendFailureMessage(600, AbAppConfig.CONNECT_EXCEPTION, new AbAppException(AbAppConfig.CONNECT_EXCEPTION));
                return;
            }
            try {
                if (params != null) {
                    url = String.valueOf(url) + params.getParamString();
                }
                HttpGet httpGet = new HttpGet(url);
                httpGet.addHeader(USER_AGENT, this.userAgent);
                httpGet.addHeader(ACCEPT_ENCODING, "gzip");
                HttpClient httpClient = this.getHttpClient();
                String response = (String)httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)new RedirectionResponseHandler(url, responseListener), this.mHttpContext);
                AbLogUtil.i(mContext, "[HTTP Request]:" + url + ",result\uff1a" + response);
            }
            catch (Exception e) {
                e.printStackTrace();
                responseListener.sendFailureMessage(900, e.getMessage(), new AbAppException(e));
            }
        }
        finally {
            responseListener.sendFinishMessage();
        }
    }

    private void doPost(String url, AbRequestParams params, AbHttpResponseListener responseListener) {
        try {
            responseListener.sendStartMessage();
            if (!AbAppUtil.isNetworkAvailable(mContext)) {
                responseListener.sendFailureMessage(600, AbAppConfig.CONNECT_EXCEPTION, new AbAppException(AbAppConfig.CONNECT_EXCEPTION));
                return;
            }
            try {
                HttpPost httpPost = new HttpPost(url);
                httpPost.addHeader(USER_AGENT, this.userAgent);
                httpPost.addHeader(ACCEPT_ENCODING, "gzip");
                if (params != null) {
                    HttpEntity httpentity = params.getEntity(responseListener);
                    httpPost.setEntity(httpentity);
                }
                HttpClient httpClient = this.getHttpClient();
                String response = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)new RedirectionResponseHandler(url, responseListener), this.mHttpContext);
                AbLogUtil.i(mContext, "request\uff1a" + url + ",result\uff1a" + response);
            }
            catch (Exception e) {
                e.printStackTrace();
                AbLogUtil.i(mContext, "request\uff1a" + url + ",error\uff1a" + e.getMessage());
                responseListener.sendFailureMessage(900, e.getMessage(), new AbAppException(e));
            }
        }
        finally {
            responseListener.sendFinishMessage();
        }
    }

    public void writeResponseData(Context context, HttpEntity entity, String name, AbFileHttpResponseListener responseListener) {
        if (entity == null) {
            return;
        }
        if (responseListener.getFile() == null) {
            responseListener.setFile(context, name);
        }
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            try {
                inStream = entity.getContent();
                long contentLength = entity.getContentLength();
                outStream = new FileOutputStream(responseListener.getFile());
                if (inStream != null) {
                    int l;
                    byte[] tmp = new byte[4096];
                    int count = 0;
                    while ((l = inStream.read(tmp)) != -1 && !Thread.currentThread().isInterrupted()) {
                        ((FileOutputStream)outStream).write(tmp, 0, l);
                        responseListener.sendProgressMessage(count += l, (int)contentLength);
                    }
                }
                responseListener.sendSuccessMessage(200);
            }
            catch (Exception e) {
                e.printStackTrace();
                responseListener.sendFailureMessage(602, AbAppConfig.SOCKET_TIMEOUT_EXCEPTION, e);
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (outStream != null) {
                        outStream.flush();
                        ((FileOutputStream)outStream).close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.flush();
                    ((FileOutputStream)outStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void readResponseData(HttpEntity entity, AbBinaryHttpResponseListener responseListener) {
        if (entity == null) {
            return;
        }
        InputStream inStream = null;
        ByteArrayOutputStream outSteam = null;
        try {
            try {
                inStream = entity.getContent();
                outSteam = new ByteArrayOutputStream();
                long contentLength = entity.getContentLength();
                if (inStream != null) {
                    int l;
                    int count = 0;
                    byte[] tmp = new byte[4096];
                    while ((l = inStream.read(tmp)) != -1) {
                        outSteam.write(tmp, 0, l);
                        responseListener.sendProgressMessage(count += l, (int)contentLength);
                    }
                }
                responseListener.sendSuccessMessage(200, outSteam.toByteArray());
            }
            catch (Exception e) {
                e.printStackTrace();
                responseListener.sendFailureMessage(602, AbAppConfig.SOCKET_TIMEOUT_EXCEPTION, e);
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (outSteam != null) {
                        outSteam.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (outSteam != null) {
                    outSteam.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setTimeout(int timeout) {
        this.mTimeout = timeout;
    }

    public BasicHttpParams getHttpParams() {
        BasicHttpParams httpParams = new BasicHttpParams();
        ConnPerRouteBean connPerRoute = new ConnPerRouteBean(30);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)httpParams, (ConnPerRoute)connPerRoute);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpParams, (boolean)false);
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)this.mTimeout);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)httpParams, (ConnPerRoute)new ConnPerRouteBean(10));
        ConnManagerParams.setMaxTotalConnections((HttpParams)httpParams, (int)10);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.mTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.mTimeout);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
        HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)httpParams, (String)this.userAgent);
        HttpClientParams.setRedirecting((HttpParams)httpParams, (boolean)false);
        HttpClientParams.setCookiePolicy((HttpParams)httpParams, (String)"compatibility");
        httpParams.setParameter("http.route.default-proxy", null);
        return httpParams;
    }

    public HttpClient getHttpClient() {
        if (this.mHttpClient != null) {
            return this.mHttpClient;
        }
        return this.createHttpClient();
    }

    public HttpClient createHttpClient() {
        BasicHttpParams httpParams = this.getHttpParams();
        if (this.mIsOpenEasySSL) {
            EasySSLProtocolSocketFactory easySSLProtocolSocketFactory = new EasySSLProtocolSocketFactory();
            SchemeRegistry supportedSchemes = new SchemeRegistry();
            PlainSocketFactory socketFactory = PlainSocketFactory.getSocketFactory();
            supportedSchemes.register(new Scheme("http", (SocketFactory)socketFactory, 80));
            supportedSchemes.register(new Scheme("https", (SocketFactory)easySSLProtocolSocketFactory, 443));
            ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager((HttpParams)httpParams, supportedSchemes);
            this.mHttpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpParams);
            this.mHttpClient.setHttpRequestRetryHandler(this.mRequestRetryHandler);
        } else {
            this.mHttpClient = new DefaultHttpClient((HttpParams)httpParams);
            this.mHttpClient.setHttpRequestRetryHandler(this.mRequestRetryHandler);
        }
        return this.mHttpClient;
    }

    public boolean isOpenEasySSL() {
        return this.mIsOpenEasySSL;
    }

    public void setOpenEasySSL(boolean isOpenEasySSL) {
        this.mIsOpenEasySSL = isOpenEasySSL;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    public void shutdown() {
        if (this.mHttpClient != null && this.mHttpClient.getConnectionManager() != null) {
            this.mHttpClient.getConnectionManager().shutdown();
        }
    }

    private class RedirectionResponseHandler
    implements ResponseHandler<String> {
        private AbHttpResponseListener mResponseListener = null;
        private String mUrl = null;

        public RedirectionResponseHandler(String url, AbHttpResponseListener responseListener) {
            this.mUrl = url;
            this.mResponseListener = responseListener;
        }

        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            HttpUriRequest request = (HttpUriRequest)AbHttpClient.this.mHttpContext.getAttribute("http.request");
            int statusCode = response.getStatusLine().getStatusCode();
            Object entity = response.getEntity();
            String responseBody = null;
            if (statusCode == 200) {
                if (entity != null) {
                    if (this.mResponseListener instanceof AbStringHttpResponseListener) {
                        String contentEncoding;
                        Header header = entity.getContentEncoding();
                        if (header != null && (contentEncoding = header.getValue()) != null && contentEncoding.contains("gzip")) {
                            entity = new AbGzipDecompressingEntity((HttpEntity)entity);
                        }
                        String charset = EntityUtils.getContentCharSet((HttpEntity)entity) == null ? AbHttpClient.this.encode : EntityUtils.getContentCharSet((HttpEntity)entity);
                        responseBody = new String(EntityUtils.toByteArray((HttpEntity)entity), charset);
                        ((AbStringHttpResponseListener)this.mResponseListener).sendSuccessMessage(statusCode, responseBody);
                    } else if (this.mResponseListener instanceof AbBinaryHttpResponseListener) {
                        responseBody = "Binary";
                        AbHttpClient.this.readResponseData((HttpEntity)entity, (AbBinaryHttpResponseListener)this.mResponseListener);
                    } else if (this.mResponseListener instanceof AbFileHttpResponseListener) {
                        String fileName = AbFileUtil.getCacheFileNameFromUrl(this.mUrl, response);
                        AbHttpClient.this.writeResponseData(mContext, (HttpEntity)entity, fileName, (AbFileHttpResponseListener)this.mResponseListener);
                    }
                    try {
                        entity.consumeContent();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return responseBody;
                }
            } else if (statusCode == 302 || statusCode == 301) {
                Header locationHeader = response.getLastHeader("location");
                String location = locationHeader.getValue();
                if (request.getMethod().equalsIgnoreCase(AbHttpClient.HTTP_POST)) {
                    AbHttpClient.this.doPost(location, null, this.mResponseListener);
                } else if (request.getMethod().equalsIgnoreCase(AbHttpClient.HTTP_GET)) {
                    AbHttpClient.this.doGet(location, null, this.mResponseListener);
                }
            } else if (statusCode == 404) {
                this.mResponseListener.sendFailureMessage(statusCode, AbAppConfig.NOT_FOUND_EXCEPTION, new AbAppException(AbAppConfig.NOT_FOUND_EXCEPTION));
            } else {
                this.mResponseListener.sendFailureMessage(statusCode, AbAppConfig.REMOTE_SERVICE_EXCEPTION, new AbAppException(AbAppConfig.REMOTE_SERVICE_EXCEPTION));
            }
            return null;
        }
    }

    private static class ResponderHandler
    extends Handler {
        private Object[] response;
        private AbHttpResponseListener responseListener;

        public ResponderHandler(AbHttpResponseListener responseListener) {
            this.responseListener = responseListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.response = (Object[])msg.obj;
                    if (this.response == null) break;
                    if (this.responseListener instanceof AbStringHttpResponseListener) {
                        if (this.response.length >= 2) {
                            ((AbStringHttpResponseListener)this.responseListener).onSuccess((Integer)this.response[0], (String)this.response[1]);
                            break;
                        }
                        AbLogUtil.e(mContext, "SUCCESS_MESSAGE " + AbAppConfig.MISSING_PARAMETERS);
                        break;
                    }
                    if (this.responseListener instanceof AbBinaryHttpResponseListener) {
                        if (this.response.length >= 2) {
                            ((AbBinaryHttpResponseListener)this.responseListener).onSuccess((Integer)this.response[0], (byte[])this.response[1]);
                            break;
                        }
                        AbLogUtil.e(mContext, "SUCCESS_MESSAGE " + AbAppConfig.MISSING_PARAMETERS);
                        break;
                    }
                    if (!(this.responseListener instanceof AbFileHttpResponseListener)) break;
                    if (this.response.length >= 1) {
                        AbFileHttpResponseListener mAbFileHttpResponseListener = (AbFileHttpResponseListener)this.responseListener;
                        mAbFileHttpResponseListener.onSuccess((Integer)this.response[0], mAbFileHttpResponseListener.getFile());
                        break;
                    }
                    AbLogUtil.e(mContext, "SUCCESS_MESSAGE " + AbAppConfig.MISSING_PARAMETERS);
                    break;
                }
                case 1: {
                    this.response = (Object[])msg.obj;
                    if (this.response != null && this.response.length >= 3) {
                        AbAppException exception = new AbAppException((Exception)this.response[2]);
                        this.responseListener.onFailure((Integer)this.response[0], (String)this.response[1], exception);
                        break;
                    }
                    AbLogUtil.e(mContext, "FAILURE_MESSAGE " + AbAppConfig.MISSING_PARAMETERS);
                    break;
                }
                case 4: {
                    this.responseListener.onStart();
                    break;
                }
                case 5: {
                    this.responseListener.onFinish();
                    break;
                }
                case 6: {
                    this.response = (Object[])msg.obj;
                    if (this.response != null && this.response.length >= 2) {
                        this.responseListener.onProgress((Integer)this.response[0], (Integer)this.response[1]);
                        break;
                    }
                    AbLogUtil.e(mContext, "PROGRESS_MESSAGE " + AbAppConfig.MISSING_PARAMETERS);
                    break;
                }
                case 7: {
                    this.responseListener.onRetry();
                    break;
                }
            }
        }
    }
}

