/*
 * Decompiled with CFR 0.152.
 */
package com.ab.fragment;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ab.fragment.AbDialogFragment;
import com.ab.util.AbViewUtil;

public class AbRefreshDialogFragment
extends AbDialogFragment {
    private int mTheme;
    private int mStyle;
    private int mIndeterminateDrawable;
    private int mTextSize = 15;
    private int mTextColor = -1;
    private View mContentView;
    private TextView mTextView = null;
    private ImageView mImageView = null;
    private int mBackgroundColor = Color.parseColor((String)"#88838B8B");

    public static AbRefreshDialogFragment newInstance(int style, int theme) {
        AbRefreshDialogFragment f = new AbRefreshDialogFragment();
        Bundle args = new Bundle();
        args.putInt("style", style);
        args.putInt("theme", theme);
        f.setArguments(args);
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mStyle = this.getArguments().getInt("style");
        this.mTheme = this.getArguments().getInt("theme");
        this.setStyle(this.mStyle, this.mTheme);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        LinearLayout parent = new LinearLayout((Context)this.getActivity());
        parent.setBackgroundColor(this.mBackgroundColor);
        parent.setGravity(17);
        parent.setOrientation(1);
        parent.setPadding(20, 20, 20, 20);
        parent.setMinimumWidth(AbViewUtil.scale((Context)this.getActivity(), 400.0f));
        this.mImageView = new ImageView((Context)this.getActivity());
        this.mImageView.setImageResource(this.mIndeterminateDrawable);
        this.mImageView.setScaleType(ImageView.ScaleType.MATRIX);
        this.mTextView = new TextView((Context)this.getActivity());
        this.mTextView.setText((CharSequence)this.mMessage);
        this.mTextView.setTextColor(this.mTextColor);
        this.mTextView.setTextSize((float)this.mTextSize);
        this.mTextView.setPadding(5, 5, 5, 5);
        parent.addView((View)this.mImageView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        parent.addView((View)this.mTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.mImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbRefreshDialogFragment.this.load(v);
            }
        });
        this.mContentView = parent;
        return this.mContentView;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(int textSize) {
        this.mTextSize = textSize;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
    }

    @Override
    public void setMessage(String message) {
        this.mMessage = message;
        if (this.mTextView != null) {
            this.mTextView.setText((CharSequence)this.mMessage);
        }
    }

    public int getIndeterminateDrawable() {
        return this.mIndeterminateDrawable;
    }

    public void setIndeterminateDrawable(int indeterminateDrawable) {
        this.mIndeterminateDrawable = indeterminateDrawable;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
    }
}

