/*
 * Decompiled with CFR 0.152.
 */
package com.ab.db.storage;

import android.content.Context;
import com.ab.db.orm.dao.AbDBDaoImpl;
import com.ab.db.storage.AbSqliteStorageListener;
import com.ab.db.storage.AbStorageQuery;
import com.ab.task.AbTaskItem;
import com.ab.task.AbTaskListListener;
import com.ab.task.AbTaskObjectListener;
import com.ab.task.AbTaskQueue;
import java.util.List;

public class AbSqliteStorage {
    private static AbSqliteStorage mSqliteStorage = null;
    private static AbTaskQueue mAbTask = null;

    public static AbSqliteStorage getInstance(Context context) {
        if (mSqliteStorage == null) {
            mSqliteStorage = new AbSqliteStorage(context);
        }
        if (mAbTask == null) {
            mAbTask = new AbTaskQueue();
        }
        return mSqliteStorage;
    }

    private AbSqliteStorage(Context context) {
    }

    public <T> void insertData(final T entity, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataInsertListener paramDataInsertListener) {
        if (entity != null) {
            AbTaskItem item = new AbTaskItem();
            item.setListener(new AbTaskObjectListener(){

                @Override
                public <T> T getObject() {
                    long rowId;
                    block6: {
                        rowId = -1L;
                        try {
                            try {
                                dao.startWritableDatabase(false);
                                rowId = dao.insert(entity);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (paramDataInsertListener != null) {
                                    paramDataInsertListener.onFailure(-101, e.getMessage());
                                }
                                dao.closeDatabase();
                                break block6;
                            }
                        }
                        catch (Throwable throwable) {
                            dao.closeDatabase();
                            throw throwable;
                        }
                        dao.closeDatabase();
                    }
                    return (T)Long.valueOf(rowId);
                }

                @Override
                public <T> void update(T obj) {
                    long rowId = (Long)obj;
                    if (paramDataInsertListener != null) {
                        if (rowId > -1L) {
                            paramDataInsertListener.onSuccess(rowId);
                        } else {
                            paramDataInsertListener.onFailure(-101, "");
                        }
                    }
                }
            });
            mAbTask.execute(item);
        } else if (paramDataInsertListener != null) {
            paramDataInsertListener.onFailure(-100, "");
        }
    }

    public <T> void insertData(final List<T> entityList, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataInsertListListener paramDataInsertListListener) {
        if (entityList != null) {
            AbTaskItem item = new AbTaskItem();
            item.setListener(new AbTaskObjectListener(){

                @Override
                public <T> T getObject() {
                    long[] rowIds;
                    block6: {
                        rowIds = null;
                        try {
                            try {
                                dao.startWritableDatabase(false);
                                rowIds = dao.insertList(entityList);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (paramDataInsertListListener != null) {
                                    paramDataInsertListListener.onFailure(-101, e.getMessage());
                                }
                                dao.closeDatabase();
                                break block6;
                            }
                        }
                        catch (Throwable throwable) {
                            dao.closeDatabase();
                            throw throwable;
                        }
                        dao.closeDatabase();
                    }
                    return (T)rowIds;
                }

                @Override
                public <T> void update(T obj) {
                    long sum = -1L;
                    long[] rowIdsBase = null;
                    if (obj != null) {
                        Long[] rowIds = (Long[])obj;
                        rowIdsBase = new long[rowIds.length];
                        int i = 0;
                        while (i < rowIds.length) {
                            long rowId = rowIds[i];
                            sum += rowId;
                            rowIdsBase[i] = rowId;
                            ++i;
                        }
                    }
                    if (paramDataInsertListListener != null) {
                        if (sum > -1L) {
                            paramDataInsertListListener.onSuccess(rowIdsBase);
                        } else {
                            paramDataInsertListListener.onFailure(-101, "");
                        }
                    }
                }
            });
            mAbTask.execute(item);
        } else if (paramDataInsertListListener != null) {
            paramDataInsertListListener.onFailure(-100, "");
        }
    }

    public <T> void findData(final AbStorageQuery storageQuery, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataSelectListener paramDataSelectListener) {
        AbTaskItem item = new AbTaskItem();
        item.setListener(new AbTaskListListener(){

            @Override
            public List<?> getList() {
                List list;
                block7: {
                    list = null;
                    try {
                        try {
                            dao.startReadableDatabase();
                            if (storageQuery.getLimit() != -1 && storageQuery.getOffset() != -1) {
                                list = dao.queryList(null, storageQuery.getWhereClause(), storageQuery.getWhereArgs(), storageQuery.getGroupBy(), storageQuery.getHaving(), String.valueOf(storageQuery.getOrderBy()) + " limit " + storageQuery.getLimit() + " offset " + storageQuery.getOffset(), null);
                                break block7;
                            }
                            list = dao.queryList(null, storageQuery.getWhereClause(), storageQuery.getWhereArgs(), storageQuery.getGroupBy(), storageQuery.getHaving(), storageQuery.getOrderBy(), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (paramDataSelectListener != null) {
                                paramDataSelectListener.onFailure(-101, e.getMessage());
                            }
                            dao.closeDatabase();
                        }
                    }
                    finally {
                        dao.closeDatabase();
                    }
                }
                return list;
            }

            @Override
            public void update(List<?> paramList) {
                if (paramDataSelectListener != null) {
                    paramDataSelectListener.onSuccess(paramList);
                }
            }
        });
        mAbTask.execute(item);
    }

    public <T> void updateData(final T entity, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataUpdateListener paramDataUpdateListener) {
        if (entity != null) {
            AbTaskItem item = new AbTaskItem();
            item.setListener(new AbTaskObjectListener(){

                @Override
                public <T> T getObject() {
                    int rows;
                    block6: {
                        rows = 0;
                        try {
                            try {
                                dao.startWritableDatabase(false);
                                rows = dao.update(entity);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (paramDataUpdateListener != null) {
                                    paramDataUpdateListener.onFailure(-101, e.getMessage());
                                }
                                dao.closeDatabase();
                                break block6;
                            }
                        }
                        catch (Throwable throwable) {
                            dao.closeDatabase();
                            throw throwable;
                        }
                        dao.closeDatabase();
                    }
                    return (T)Long.valueOf(rows);
                }

                @Override
                public <T> void update(T obj) {
                    int rows = (Integer)obj;
                    if (paramDataUpdateListener != null) {
                        if (rows > 0) {
                            paramDataUpdateListener.onSuccess(rows);
                        } else {
                            paramDataUpdateListener.onFailure(-101, "");
                        }
                    }
                }
            });
            mAbTask.execute(item);
        } else if (paramDataUpdateListener != null) {
            paramDataUpdateListener.onFailure(-100, "");
        }
    }

    public <T> void updateData(final List<T> entityList, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataUpdateListener paramDataUpdateListener) {
        if (entityList != null) {
            AbTaskItem item = new AbTaskItem();
            item.setListener(new AbTaskObjectListener(){

                @Override
                public <T> T getObject() {
                    int rows;
                    block6: {
                        rows = 0;
                        try {
                            try {
                                dao.startWritableDatabase(false);
                                rows = dao.updateList(entityList);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (paramDataUpdateListener != null) {
                                    paramDataUpdateListener.onFailure(-101, e.getMessage());
                                }
                                dao.closeDatabase();
                                break block6;
                            }
                        }
                        catch (Throwable throwable) {
                            dao.closeDatabase();
                            throw throwable;
                        }
                        dao.closeDatabase();
                    }
                    return (T)Integer.valueOf(rows);
                }

                @Override
                public <T> void update(T obj) {
                    block5: {
                        try {
                            int ret = (Integer)obj;
                            if (paramDataUpdateListener != null) {
                                if (ret >= 0) {
                                    paramDataUpdateListener.onSuccess(ret);
                                } else {
                                    paramDataUpdateListener.onFailure(-101, "");
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (paramDataUpdateListener == null) break block5;
                            paramDataUpdateListener.onFailure(-101, e.getMessage());
                        }
                    }
                }
            });
            mAbTask.execute(item);
        } else if (paramDataUpdateListener != null) {
            paramDataUpdateListener.onFailure(-100, "");
        }
    }

    public <T> void deleteData(final AbStorageQuery storageQuery, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataDeleteListener paramDataDeleteListener) {
        AbTaskItem item = new AbTaskItem();
        item.setListener(new AbTaskObjectListener(){

            @Override
            public <T> T getObject() {
                int rows;
                block6: {
                    rows = 0;
                    try {
                        try {
                            dao.startWritableDatabase(false);
                            rows = dao.delete(storageQuery.getWhereClause(), storageQuery.getWhereArgs());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (paramDataDeleteListener != null) {
                                paramDataDeleteListener.onFailure(-101, e.getMessage());
                            }
                            dao.closeDatabase();
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        dao.closeDatabase();
                        throw throwable;
                    }
                    dao.closeDatabase();
                }
                return (T)Integer.valueOf(rows);
            }

            @Override
            public <T> void update(T obj) {
                int rows = (Integer)obj;
                if (paramDataDeleteListener != null) {
                    if (rows >= 0) {
                        paramDataDeleteListener.onSuccess(rows);
                    } else {
                        paramDataDeleteListener.onFailure(-101, "");
                    }
                }
            }
        });
        mAbTask.execute(item);
    }

    public void release() {
        if (mAbTask != null) {
            mAbTask.cancel(true);
            mAbTask = null;
        }
    }
}

