/*
 * Decompiled with CFR 0.152.
 */
package com.ab.db.orm.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.ab.db.AbBasicDBDao;
import com.ab.db.orm.AbTableHelper;
import com.ab.db.orm.annotation.Column;
import com.ab.db.orm.annotation.Id;
import com.ab.db.orm.annotation.Relations;
import com.ab.db.orm.annotation.Table;
import com.ab.db.orm.dao.AbDBDao;
import com.ab.util.AbLogUtil;
import com.ab.util.AbStrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class AbDBDaoImpl<T>
extends AbBasicDBDao
implements AbDBDao<T> {
    private SQLiteOpenHelper dbHelper;
    private final ReentrantLock lock = new ReentrantLock();
    private String tableName;
    private String idColumn;
    private Class<T> clazz;
    private List<Field> allFields;
    private static final int METHOD_INSERT = 0;
    private static final int METHOD_UPDATE = 1;
    private static final int TYPE_NOT_INCREMENT = 0;
    private static final int TYPE_INCREMENT = 1;
    private SQLiteDatabase db = null;

    public AbDBDaoImpl(SQLiteOpenHelper dbHelper, Class<T> clazz) {
        this.dbHelper = dbHelper;
        this.clazz = clazz == null ? (Class)((ParameterizedType)super.getClass().getGenericSuperclass()).getActualTypeArguments()[0] : clazz;
        if (this.clazz.isAnnotationPresent(Table.class)) {
            Table table = this.clazz.getAnnotation(Table.class);
            this.tableName = table.name();
        }
        this.allFields = AbTableHelper.joinFields(this.clazz.getDeclaredFields(), this.clazz.getSuperclass().getDeclaredFields());
        for (Field field : this.allFields) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            Column column = field.getAnnotation(Column.class);
            this.idColumn = column.name();
            break;
        }
        AbLogUtil.d(AbDBDaoImpl.class, "clazz:" + this.clazz + " tableName:" + this.tableName + " idColumn:" + this.idColumn);
    }

    public AbDBDaoImpl(SQLiteOpenHelper dbHelper) {
        this(dbHelper, null);
    }

    @Override
    public SQLiteOpenHelper getDbHelper() {
        return this.dbHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T queryOne(int id) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            String selection = String.valueOf(this.idColumn) + " = ?";
            String[] selectionArgs = new String[]{Integer.toString(id)};
            AbLogUtil.d(AbDBDaoImpl.class, "[queryOne]: select * from " + this.tableName + " where " + this.idColumn + " = '" + id + "'");
            List<T> list = this.queryList(null, selection, selectionArgs, null, null, null, null);
            if (list != null && list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
    }

    @Override
    public List<T> rawQuery(String sql, String[] selectionArgs, Class<T> clazz) {
        ArrayList list;
        block5: {
            list = new ArrayList();
            Cursor cursor = null;
            try {
                try {
                    this.lock.lock();
                    this.checkDBOpened();
                    AbLogUtil.d(AbDBDaoImpl.class, "[rawQuery]: " + this.getLogSql(sql, selectionArgs));
                    cursor = this.db.rawQuery(sql, selectionArgs);
                    this.getListFromCursor(clazz, list, cursor);
                }
                catch (Exception e) {
                    AbLogUtil.e(AbDBDaoImpl.class, "[rawQuery] from DB Exception.");
                    e.printStackTrace();
                    this.closeCursor(cursor);
                    this.lock.unlock();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                this.lock.unlock();
                throw throwable;
            }
            this.closeCursor(cursor);
            this.lock.unlock();
        }
        return list;
    }

    @Override
    public boolean isExist(String sql, String[] selectionArgs) {
        block7: {
            Cursor cursor = null;
            try {
                this.lock.lock();
                this.checkDBOpened();
                AbLogUtil.d(AbDBDaoImpl.class, "[isExist]: " + this.getLogSql(sql, selectionArgs));
                cursor = this.db.rawQuery(sql, selectionArgs);
                if (cursor.getCount() > 0) {
                    this.closeCursor(cursor);
                    this.lock.unlock();
                    return true;
                }
            }
            catch (Exception e) {
                AbLogUtil.e(AbDBDaoImpl.class, "[isExist] from DB Exception.");
                e.printStackTrace();
                break block7;
            }
            finally {
                this.closeCursor(cursor);
                this.lock.unlock();
            }
            this.closeCursor(cursor);
            this.lock.unlock();
        }
        return false;
    }

    @Override
    public List<T> queryList() {
        return this.queryList(null, null, null, null, null, null, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> queryList(String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        block21: {
            block20: {
                list = new ArrayList<E>();
                cursor = null;
                try {
                    this.lock.lock();
                    this.checkDBOpened();
                    AbLogUtil.d(AbDBDaoImpl.class, "[queryList] from " + this.tableName + " where " + selection + "(" + selectionArgs + ")" + " group by " + groupBy + " having " + having + " order by " + orderBy + " limit " + limit);
                    cursor = this.db.query(this.tableName, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
                    this.getListFromCursor(this.clazz, list, cursor);
                    this.closeCursor(cursor);
                    foreignKey = null;
                    type = null;
                    action = null;
lbl13:
                    // 3 sources

                    for (Field relationsField : this.allFields) {
                        if (!relationsField.isAnnotationPresent(Relations.class)) continue;
                        relations = relationsField.getAnnotation(Relations.class);
                        foreignKey = relations.foreignKey();
                        type = relations.type();
                        action = relations.action();
                        relationsField.setAccessible(true);
                        if (action.indexOf("query") == -1) {
                            var33_37 = list;
                            break block20;
                        }
                        ** GOTO lbl-1000
                    }
                    break block21;
                }
                catch (Exception e) {
                    AbLogUtil.e(AbDBDaoImpl.class, "[queryList] from DB Exception");
                    e.printStackTrace();
                    this.closeCursor(cursor);
                    this.lock.unlock();
                    return list;
                }
                catch (Throwable var32_38) {
                    this.closeCursor(cursor);
                    this.lock.unlock();
                    throw var32_38;
                }
            }
            this.closeCursor(cursor);
            this.lock.unlock();
            return var33_37;
lbl-1000:
            // 9 sources

            {
                block7: for (E entity : list) {
                    if ("one2one".equals(type)) {
                        relationsTableName = "";
                        if (relationsField.getType().isAnnotationPresent(Table.class)) {
                            table = relationsField.getType().getAnnotation(Table.class);
                            relationsTableName = table.name();
                        }
                        relationsList = new ArrayList<E>();
                        var24_27 = relationsEntityFields = relationsField.getType().getDeclaredFields();
                        var23_25 = relationsEntityFields.length;
                        var22_23 = 0;
                        while (var22_23 < var23_25) {
                            relationsEntityField = var24_27[var22_23];
                            relationsEntityColumn = relationsEntityField.getAnnotation(Column.class);
                            if (relationsEntityColumn != null && relationsEntityColumn.name().equals(foreignKey)) {
                                value = "-1";
                                for (Field entityField : this.allFields) {
                                    entityField.setAccessible(true);
                                    entityForeignKeyColumn = entityField.getAnnotation(Column.class);
                                    if (entityForeignKeyColumn == null || !entityForeignKeyColumn.name().equals(foreignKey)) continue;
                                    value = String.valueOf(entityField.get(entity));
                                    break;
                                }
                                cursor = this.db.query(relationsTableName, null, String.valueOf(foreignKey) + " = ?", new String[]{value}, null, null, null, null);
                                this.getListFromCursor(relationsField.getType(), relationsList, cursor);
                                if (relationsList.size() <= 0) continue block7;
                                relationsField.set(entity, relationsList.get(0));
                                continue block7;
                            }
                            ++var22_23;
                        }
                        continue;
                    }
                    if (!"one2many".equals(type) && !"many2many".equals(type)) continue;
                    listEntityClazz = null;
                    fieldClass = relationsField.getType();
                    if (fieldClass.isAssignableFrom(List.class)) {
                        fc = relationsField.getGenericType();
                        if (fc == null) continue;
                        if (fc instanceof ParameterizedType) {
                            pt = (ParameterizedType)fc;
                            listEntityClazz = (Class)pt.getActualTypeArguments()[0];
                        }
                    }
                    if (listEntityClazz != null) break block22;
                    AbLogUtil.e(AbDBDaoImpl.class, "\u5bf9\u8c61\u6a21\u578b\u9700\u8981\u8bbe\u7f6eList\u7684\u6cdb\u578b");
                }
                ** GOTO lbl13
            }
            {
                block22: {
                    this.closeCursor(cursor);
                    this.lock.unlock();
                    return null;
                }
                relationsTableName = "";
                if (listEntityClazz.isAnnotationPresent(Table.class)) {
                    table = listEntityClazz.getAnnotation(Table.class);
                    relationsTableName = table.name();
                }
                relationsList = new ArrayList<E>();
                var26_31 = relationsEntityFields = listEntityClazz.getDeclaredFields();
                var25_30 = relationsEntityFields.length;
                var24_28 = 0;
                while (var24_28 < var25_30) {
                    relationsEntityField = var26_31[var24_28];
                    relationsEntityColumn = relationsEntityField.getAnnotation(Column.class);
                    if (relationsEntityColumn != null && relationsEntityColumn.name().equals(foreignKey)) {
                        value = "-1";
                        for (Field entityField : this.allFields) {
                            entityField.setAccessible(true);
                            entityForeignKeyColumn = entityField.getAnnotation(Column.class);
                            if (!entityForeignKeyColumn.name().equals(foreignKey)) continue;
                            value = String.valueOf(entityField.get(entity));
                            break;
                        }
                        cursor = this.db.query(relationsTableName, null, String.valueOf(foreignKey) + " = ?", new String[]{value}, null, null, null, null);
                        this.getListFromCursor(listEntityClazz, relationsList, cursor);
                        if (relationsList.size() <= 0) continue block7;
                        relationsField.set(entity, relationsList);
                        continue block7;
                    }
                    ++var24_28;
                }
                continue;
                break;
            }
        }
        this.closeCursor(cursor);
        this.lock.unlock();
        return list;
    }

    @Override
    public List<T> queryList(String selection, String[] selectionArgs) {
        return this.queryList(null, selection, selectionArgs, null, null, null, null);
    }

    private void getListFromCursor(Class<?> clazz, List<T> list, Cursor cursor) throws IllegalAccessException, InstantiationException {
        while (cursor.moveToNext()) {
            Object entity = clazz.newInstance();
            List<Field> allFields = AbTableHelper.joinFields(entity.getClass().getDeclaredFields(), entity.getClass().getSuperclass().getDeclaredFields());
            for (Field field : allFields) {
                Column column = null;
                if (!field.isAnnotationPresent(Column.class)) continue;
                column = field.getAnnotation(Column.class);
                field.setAccessible(true);
                Class<?> fieldType = field.getType();
                int c = cursor.getColumnIndex(column.name());
                if (c < 0) continue;
                if (Integer.TYPE == fieldType || Integer.class == fieldType) {
                    field.set(entity, cursor.getInt(c));
                    continue;
                }
                if (String.class == fieldType) {
                    field.set(entity, cursor.getString(c));
                    continue;
                }
                if (Long.TYPE == fieldType || Long.class == fieldType) {
                    field.set(entity, cursor.getLong(c));
                    continue;
                }
                if (Float.TYPE == fieldType || Float.class == fieldType) {
                    field.set(entity, Float.valueOf(cursor.getFloat(c)));
                    continue;
                }
                if (Short.TYPE == fieldType || Short.class == fieldType) {
                    field.set(entity, cursor.getShort(c));
                    continue;
                }
                if (Double.TYPE == fieldType || Double.class == fieldType) {
                    field.set(entity, cursor.getDouble(c));
                    continue;
                }
                if (Date.class == fieldType) {
                    Date date = new Date();
                    date.setTime(cursor.getLong(c));
                    field.set(entity, date);
                    continue;
                }
                if (Blob.class == fieldType) {
                    field.set(entity, cursor.getBlob(c));
                    continue;
                }
                if (Character.TYPE == fieldType) {
                    String fieldValue = cursor.getString(c);
                    if (fieldValue == null || fieldValue.length() <= 0) continue;
                    field.set(entity, Character.valueOf(fieldValue.charAt(0)));
                    continue;
                }
                if (Boolean.TYPE != fieldType && Boolean.class != fieldType) continue;
                String temp = cursor.getString(c);
                if ("true".equals(temp) || "1".equals(temp)) {
                    field.set(entity, true);
                    continue;
                }
                field.set(entity, false);
            }
            list.add(entity);
        }
    }

    @Override
    public long insert(T entity) {
        return this.insert(entity, true);
    }

    @Override
    public long insert(T entity, boolean flag) {
        String sql = null;
        long rowId = -1L;
        try {
            this.lock.lock();
            this.checkDBOpened();
            ContentValues cv = new ContentValues();
            sql = flag ? this.setContentValues(entity, cv, 1, 0) : this.setContentValues(entity, cv, 0, 0);
            AbLogUtil.d(AbDBDaoImpl.class, "[insert]: insert into " + this.tableName + " " + sql);
            rowId = this.db.insert(this.tableName, null, cv);
            String foreignKey = null;
            String type = null;
            String action = null;
            for (Field relationsField : this.allFields) {
                if (!relationsField.isAnnotationPresent(Relations.class)) continue;
                Relations relations = relationsField.getAnnotation(Relations.class);
                foreignKey = relations.foreignKey();
                type = relations.type();
                action = relations.action();
                relationsField.setAccessible(true);
                if (action.indexOf("insert") == -1) {
                    long l = rowId;
                    return l;
                }
                try {
                    List list;
                    if ("one2one".equals(type)) {
                        Object relationsEntity = relationsField.get(entity);
                        if (relationsEntity == null) continue;
                        ContentValues relationsCv = new ContentValues();
                        sql = flag ? this.setContentValues(relationsEntity, relationsCv, 1, 0) : this.setContentValues(relationsEntity, relationsCv, 0, 0);
                        String relationsTableName = "";
                        if (relationsEntity.getClass().isAnnotationPresent(Table.class)) {
                            Table table = relationsEntity.getClass().getAnnotation(Table.class);
                            relationsTableName = table.name();
                        }
                        AbLogUtil.d(AbDBDaoImpl.class, "[insert]: insert into " + relationsTableName + " " + sql);
                        this.db.insert(relationsTableName, null, relationsCv);
                        continue;
                    }
                    if (!"one2many".equals(type) && !"many2many".equals(type) || (list = (List)relationsField.get(entity)) == null || list.size() <= 0) continue;
                    for (Object relationsEntity : list) {
                        ContentValues relationsCv = new ContentValues();
                        sql = flag ? this.setContentValues(relationsEntity, relationsCv, 1, 0) : this.setContentValues(relationsEntity, relationsCv, 0, 0);
                        String relationsTableName = "";
                        if (relationsEntity.getClass().isAnnotationPresent(Table.class)) {
                            Table table = relationsEntity.getClass().getAnnotation(Table.class);
                            relationsTableName = table.name();
                        }
                        AbLogUtil.d(AbDBDaoImpl.class, "[insert]: insert into " + relationsTableName + " " + sql);
                        this.db.insert(relationsTableName, null, relationsCv);
                    }
                    continue;
                }
                catch (Exception e) {
                    AbLogUtil.d(AbDBDaoImpl.class, "[insert] into DB Exception.");
                    e.printStackTrace();
                }
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
        return rowId;
    }

    @Override
    public long[] insertList(List<T> entityList) {
        return this.insertList(entityList, true);
    }

    @Override
    public long[] insertList(List<T> entityList, boolean flag) {
        String sql = null;
        long[] rowIds = new long[entityList.size()];
        int i = 0;
        while (i < rowIds.length) {
            rowIds[i] = -1L;
            ++i;
        }
        try {
            try {
                this.lock.lock();
                this.checkDBOpened();
                i = 0;
                while (i < entityList.size()) {
                    T entity = entityList.get(i);
                    ContentValues cv = new ContentValues();
                    sql = flag ? this.setContentValues(entity, cv, 1, 0) : this.setContentValues(entity, cv, 0, 0);
                    AbLogUtil.d(AbDBDaoImpl.class, "[insertList]: insert into " + this.tableName + " " + sql);
                    rowIds[i] = this.db.insert(this.tableName, null, cv);
                    String foreignKey = null;
                    String type = null;
                    String action = null;
                    Field field = null;
                    for (Field relationsField : this.allFields) {
                        if (!relationsField.isAnnotationPresent(Relations.class)) continue;
                        Relations relations = relationsField.getAnnotation(Relations.class);
                        foreignKey = relations.foreignKey();
                        type = relations.type();
                        action = relations.action();
                        relationsField.setAccessible(true);
                        field = relationsField;
                    }
                    if (field != null && action.indexOf("insert") != -1) {
                        List list;
                        if ("one2one".equals(type)) {
                            Object relationsEntity = field.get(entity);
                            if (relationsEntity != null) {
                                ContentValues relationsCv = new ContentValues();
                                sql = flag ? this.setContentValues(relationsEntity, relationsCv, 1, 0) : this.setContentValues(relationsEntity, relationsCv, 0, 0);
                                String relationsTableName = "";
                                if (relationsEntity.getClass().isAnnotationPresent(Table.class)) {
                                    Table table = relationsEntity.getClass().getAnnotation(Table.class);
                                    relationsTableName = table.name();
                                }
                                AbLogUtil.d(AbDBDaoImpl.class, "[insertList]: insert into " + relationsTableName + " " + sql);
                                this.db.insert(relationsTableName, null, relationsCv);
                            }
                        } else if (("one2many".equals(type) || "many2many".equals(type)) && (list = (List)field.get(entity)) != null && list.size() > 0) {
                            for (Object relationsEntity : list) {
                                ContentValues relationsCv = new ContentValues();
                                sql = flag ? this.setContentValues(relationsEntity, relationsCv, 1, 0) : this.setContentValues(relationsEntity, relationsCv, 0, 0);
                                String relationsTableName = "";
                                if (relationsEntity.getClass().isAnnotationPresent(Table.class)) {
                                    Table table = relationsEntity.getClass().getAnnotation(Table.class);
                                    relationsTableName = table.name();
                                }
                                AbLogUtil.d(AbDBDaoImpl.class, "[insertList]: insert into " + relationsTableName + " " + sql);
                                this.db.insert(relationsTableName, null, relationsCv);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                AbLogUtil.d(AbDBDaoImpl.class, "[insertList] into DB Exception.");
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
        return rowIds;
    }

    @Override
    public int delete(int id) {
        int rows = 0;
        try {
            try {
                this.lock.lock();
                this.checkDBOpened();
                String where = String.valueOf(this.idColumn) + " = ?";
                String[] whereValue = new String[]{Integer.toString(id)};
                AbLogUtil.d(AbDBDaoImpl.class, "[delete]: delelte from " + this.tableName + " where " + where.replace("?", String.valueOf(id)));
                rows = this.db.delete(this.tableName, where, whereValue);
            }
            catch (Exception e) {
                AbLogUtil.d(AbDBDaoImpl.class, "[delete] DB Exception.");
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
        return rows;
    }

    @Override
    public int delete(Integer ... ids) {
        int rows = 0;
        if (ids.length > 0) {
            int i = 0;
            while (i < ids.length) {
                rows += this.delete((int)ids[i]);
                ++i;
            }
        }
        return rows;
    }

    @Override
    public int delete(String whereClause, String[] whereArgs) {
        int rows = 0;
        try {
            try {
                this.lock.lock();
                this.checkDBOpened();
                String mLogSql = this.getLogSql(whereClause, whereArgs);
                if (!AbStrUtil.isEmpty(mLogSql)) {
                    mLogSql = String.valueOf(mLogSql) + " where ";
                }
                AbLogUtil.d(AbDBDaoImpl.class, "[delete]: delete from " + this.tableName + mLogSql);
                rows = this.db.delete(this.tableName, whereClause, whereArgs);
            }
            catch (Exception e) {
                AbLogUtil.d(AbDBDaoImpl.class, "[delete] DB Exception.");
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
        return rows;
    }

    @Override
    public int deleteAll() {
        int rows = 0;
        try {
            try {
                this.lock.lock();
                this.checkDBOpened();
                AbLogUtil.d(AbDBDaoImpl.class, "[delete]: delete from " + this.tableName);
                rows = this.db.delete(this.tableName, null, null);
            }
            catch (Exception e) {
                AbLogUtil.d(AbDBDaoImpl.class, "[delete] DB Exception.");
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
        return rows;
    }

    @Override
    public int update(T entity) {
        int rows = 0;
        try {
            try {
                this.lock.lock();
                this.checkDBOpened();
                ContentValues cv = new ContentValues();
                String sql = this.setContentValues(entity, cv, 0, 1);
                String where = String.valueOf(this.idColumn) + " = ?";
                int id = Integer.parseInt(cv.get(this.idColumn).toString());
                cv.remove(this.idColumn);
                AbLogUtil.d(AbDBDaoImpl.class, "[update]: update " + this.tableName + " set " + sql + " where " + where.replace("?", String.valueOf(id)));
                String[] whereValue = new String[]{Integer.toString(id)};
                rows = this.db.update(this.tableName, cv, where, whereValue);
            }
            catch (Exception e) {
                AbLogUtil.d(AbDBDaoImpl.class, "[update] DB Exception.");
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
        return rows;
    }

    @Override
    public int updateList(List<T> entityList) {
        String sql = null;
        int rows = 0;
        try {
            try {
                this.lock.lock();
                this.checkDBOpened();
                for (T entity : entityList) {
                    ContentValues cv = new ContentValues();
                    sql = this.setContentValues(entity, cv, 0, 1);
                    String where = String.valueOf(this.idColumn) + " = ?";
                    int id = Integer.parseInt(cv.get(this.idColumn).toString());
                    cv.remove(this.idColumn);
                    AbLogUtil.d(AbDBDaoImpl.class, "[update]: update " + this.tableName + " set " + sql + " where " + where.replace("?", String.valueOf(id)));
                    String[] whereValue = new String[]{Integer.toString(id)};
                    rows += this.db.update(this.tableName, cv, where, whereValue);
                }
            }
            catch (Exception e) {
                AbLogUtil.d(AbDBDaoImpl.class, "[update] DB Exception.");
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
        return rows;
    }

    private String setContentValues(T entity, ContentValues cv, int type, int method) throws IllegalAccessException {
        StringBuffer strField = new StringBuffer("(");
        StringBuffer strValue = new StringBuffer(" values(");
        StringBuffer strUpdate = new StringBuffer(" ");
        List<Field> allFields = AbTableHelper.joinFields(entity.getClass().getDeclaredFields(), entity.getClass().getSuperclass().getDeclaredFields());
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            Column column = field.getAnnotation(Column.class);
            field.setAccessible(true);
            Object fieldValue = field.get(entity);
            if (fieldValue == null || type == 1 && field.isAnnotationPresent(Id.class)) continue;
            if (Date.class == field.getType()) {
                cv.put(column.name(), Long.valueOf(((Date)fieldValue).getTime()));
                continue;
            }
            String value = String.valueOf(fieldValue);
            cv.put(column.name(), value);
            if (method == 0) {
                strField.append(column.name()).append(",");
                strValue.append("'").append(value).append("',");
                continue;
            }
            strUpdate.append(column.name()).append("=").append("'").append(value).append("',");
        }
        if (method == 0) {
            strField.deleteCharAt(strField.length() - 1).append(")");
            strValue.deleteCharAt(strValue.length() - 1).append(")");
            return String.valueOf(strField.toString()) + strValue.toString();
        }
        return strUpdate.deleteCharAt(strUpdate.length() - 1).append(" ").toString();
    }

    @Override
    public List<Map<String, String>> queryMapList(String sql, String[] selectionArgs) {
        ArrayList<Map<String, String>> retList;
        block8: {
            Cursor cursor = null;
            retList = new ArrayList<Map<String, String>>();
            try {
                try {
                    this.lock.lock();
                    this.checkDBOpened();
                    AbLogUtil.d(AbDBDaoImpl.class, "[queryMapList]: " + this.getLogSql(sql, selectionArgs));
                    cursor = this.db.rawQuery(sql, selectionArgs);
                    while (cursor.moveToNext()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        String[] stringArray = cursor.getColumnNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String columnName = stringArray[n2];
                            int c = cursor.getColumnIndex(columnName);
                            if (c >= 0) {
                                map.put(columnName.toLowerCase(), cursor.getString(c));
                            }
                            ++n2;
                        }
                        retList.add(map);
                    }
                }
                catch (Exception e) {
                    AbLogUtil.e(AbDBDaoImpl.class, "[queryMapList] from DB exception");
                    e.printStackTrace();
                    this.closeCursor(cursor);
                    this.lock.unlock();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                this.lock.unlock();
                throw throwable;
            }
            this.closeCursor(cursor);
            this.lock.unlock();
        }
        return retList;
    }

    @Override
    public int queryCount(String sql, String[] selectionArgs) {
        int count;
        block6: {
            Cursor cursor = null;
            count = 0;
            try {
                try {
                    this.lock.lock();
                    this.checkDBOpened();
                    AbLogUtil.d(AbDBDaoImpl.class, "[queryCount]: " + this.getLogSql(sql, selectionArgs));
                    cursor = this.db.query(this.tableName, null, sql, selectionArgs, null, null, null);
                    if (cursor != null) {
                        count = cursor.getCount();
                    }
                }
                catch (Exception e) {
                    AbLogUtil.e(AbDBDaoImpl.class, "[queryCount] from DB exception");
                    e.printStackTrace();
                    this.closeCursor(cursor);
                    this.lock.unlock();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                this.lock.unlock();
                throw throwable;
            }
            this.closeCursor(cursor);
            this.lock.unlock();
        }
        return count;
    }

    @Override
    public void execSql(String sql, Object[] selectionArgs) {
        block6: {
            try {
                try {
                    this.lock.lock();
                    this.checkDBOpened();
                    AbLogUtil.d(AbDBDaoImpl.class, "[execSql]: " + this.getLogSql(sql, selectionArgs));
                    if (selectionArgs == null) {
                        this.db.execSQL(sql);
                        break block6;
                    }
                    this.db.execSQL(sql, selectionArgs);
                }
                catch (Exception e) {
                    AbLogUtil.e(AbDBDaoImpl.class, "[execSql] DB exception.");
                    e.printStackTrace();
                    this.lock.unlock();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void startWritableDatabase(boolean transaction) {
        try {
            try {
                this.lock.lock();
                if (this.db == null || !this.db.isOpen()) {
                    this.db = this.dbHelper.getWritableDatabase();
                }
                if (this.db != null && transaction) {
                    this.db.beginTransaction();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void startReadableDatabase() {
        try {
            try {
                this.lock.lock();
                if (this.db == null || !this.db.isOpen()) {
                    this.db = this.dbHelper.getReadableDatabase();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeDatabase() {
        try {
            try {
                this.lock.lock();
                if (this.db != null) {
                    if (this.db.inTransaction()) {
                        this.db.setTransactionSuccessful();
                        this.db.endTransaction();
                    }
                    if (this.db.isOpen()) {
                        this.db.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private String getLogSql(String sql, Object[] args) {
        if (args == null || args.length == 0) {
            return sql;
        }
        int i = 0;
        while (i < args.length) {
            sql = sql.replaceFirst("\\?", "'" + String.valueOf(args[i]) + "'");
            ++i;
        }
        return sql;
    }

    private void checkDBOpened() {
        if (this.db == null) {
            throw new RuntimeException("\u5148\u8c03\u7528 startReadableDatabase()\u6216\u8005startWritableDatabase(boolean transaction)\u521d\u59cb\u5316\u6570\u636e\u5e93\u3002");
        }
    }
}

