/*
 * Decompiled with CFR 0.152.
 */
package com.ab.db.orm;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import java.io.File;

public abstract class AbSDSQLiteOpenHelper
extends SQLiteOpenHelper {
    private final Context mContext;
    private final String mName;
    private final String mDir;
    private final SQLiteDatabase.CursorFactory mFactory;
    private final int mNewVersion;
    private SQLiteDatabase mDatabase = null;
    private boolean mIsInitializing = false;

    public AbSDSQLiteOpenHelper(Context context, String dir, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        this.mContext = context;
        this.mDir = dir;
        this.mName = name;
        this.mFactory = factory;
        this.mNewVersion = version;
    }

    public synchronized SQLiteDatabase getWritableDatabase() {
        if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("\u6570\u636e\u5e93\u5df2\u88ab\u5360\u7528getWritableDatabase()");
        }
        boolean success = false;
        SQLiteDatabase db = null;
        try {
            this.mIsInitializing = true;
            if (this.mName == null) {
                db = SQLiteDatabase.create(null);
            } else {
                String path = String.valueOf(this.mDir) + File.separator + this.mName;
                db = SQLiteDatabase.openOrCreateDatabase((String)path, (SQLiteDatabase.CursorFactory)this.mFactory);
            }
            int version = db.getVersion();
            if (version != this.mNewVersion) {
                db.beginTransaction();
                try {
                    if (version == 0) {
                        this.onCreate(db);
                    } else {
                        this.onUpgrade(db, version, this.mNewVersion);
                    }
                    db.setVersion(this.mNewVersion);
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            this.onOpen(db);
            success = true;
            SQLiteDatabase sQLiteDatabase = db;
            return sQLiteDatabase;
        }
        finally {
            this.mIsInitializing = false;
            if (success) {
                if (this.mDatabase != null) {
                    try {
                        this.mDatabase.close();
                    }
                    catch (Exception exception) {}
                }
                this.mDatabase = db;
            } else if (db != null) {
                db.close();
            }
        }
    }

    public synchronized SQLiteDatabase getReadableDatabase() {
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("\u6570\u636e\u5e93\u5df2\u88ab\u5360\u7528getReadableDatabase()");
        }
        SQLiteDatabase db = null;
        try {
            this.mDatabase = db = this.getWritableDatabase();
        }
        catch (Exception e1) {
            try {
                this.mIsInitializing = true;
                String path = String.valueOf(this.mDir) + File.separator + this.mName;
                db = SQLiteDatabase.openDatabase((String)path, (SQLiteDatabase.CursorFactory)this.mFactory, (int)1);
                if (db.getVersion() != this.mNewVersion) {
                    throw new SQLiteException("\u4e0d\u80fd\u66f4\u65b0\u53ea\u8bfb\u6570\u636e\u5e93\u7684\u7248\u672c from version " + db.getVersion() + " to " + this.mNewVersion + ": " + path);
                }
                this.onOpen(db);
                SQLiteDatabase sQLiteDatabase = this.mDatabase = db;
                return sQLiteDatabase;
            }
            catch (SQLiteException sQLiteException) {
            }
            finally {
                this.mIsInitializing = false;
                if (db != null && db != this.mDatabase) {
                    db.close();
                }
            }
        }
        return this.mDatabase;
    }

    public void onOpen(SQLiteDatabase db) {
    }

    public synchronized void close() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);
}

