/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.sero.messaging;

import com.zgkxzx.modbus4And.sero.messaging.DataConsumer;
import com.zgkxzx.modbus4And.sero.messaging.InputStreamListener;
import com.zgkxzx.modbus4And.sero.messaging.Transport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamTransport
implements Transport,
Runnable {
    protected OutputStream out;
    protected InputStream in;
    private InputStreamListener listener;

    public StreamTransport(InputStream in, OutputStream out) {
        this.out = out;
        this.in = in;
    }

    public void setReadDelay(int readDelay) {
        if (this.listener != null) {
            this.listener.setReadDelay(readDelay);
        }
    }

    public void start(String threadName) {
        this.listener.start(threadName);
    }

    public void stop() {
        this.listener.stop();
    }

    @Override
    public void run() {
        this.listener.run();
    }

    @Override
    public void setConsumer(DataConsumer consumer) {
        this.listener = new InputStreamListener(this.in, consumer);
    }

    @Override
    public void removeConsumer() {
        this.listener.stop();
        this.listener = null;
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.out.write(data);
        this.out.flush();
    }

    @Override
    public void write(byte[] data, int len) throws IOException {
        this.out.write(data, 0, len);
        this.out.flush();
    }
}

