/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.sero.messaging;

import com.zgkxzx.modbus4And.sero.io.StreamUtils;
import com.zgkxzx.modbus4And.sero.messaging.DataConsumer;
import com.zgkxzx.modbus4And.sero.messaging.DefaultMessagingExceptionHandler;
import com.zgkxzx.modbus4And.sero.messaging.IncomingMessage;
import com.zgkxzx.modbus4And.sero.messaging.IncomingRequestMessage;
import com.zgkxzx.modbus4And.sero.messaging.IncomingResponseMessage;
import com.zgkxzx.modbus4And.sero.messaging.MessageParser;
import com.zgkxzx.modbus4And.sero.messaging.MessagingExceptionHandler;
import com.zgkxzx.modbus4And.sero.messaging.OutgoingRequestMessage;
import com.zgkxzx.modbus4And.sero.messaging.OutgoingResponseMessage;
import com.zgkxzx.modbus4And.sero.messaging.RequestHandler;
import com.zgkxzx.modbus4And.sero.messaging.TimeoutException;
import com.zgkxzx.modbus4And.sero.messaging.Transport;
import com.zgkxzx.modbus4And.sero.messaging.WaitingRoom;
import com.zgkxzx.modbus4And.sero.messaging.WaitingRoomKey;
import com.zgkxzx.modbus4And.sero.messaging.WaitingRoomKeyFactory;
import com.zgkxzx.modbus4And.sero.timer.SystemTimeSource;
import com.zgkxzx.modbus4And.sero.timer.TimeSource;
import com.zgkxzx.modbus4And.sero.util.queue.ByteQueue;
import java.io.IOException;

public class MessageControl
implements DataConsumer {
    private static int DEFAULT_RETRIES = 2;
    private static int DEFAULT_TIMEOUT = 500;
    public boolean DEBUG = false;
    private Transport transport;
    private MessageParser messageParser;
    private RequestHandler requestHandler;
    private WaitingRoomKeyFactory waitingRoomKeyFactory;
    private MessagingExceptionHandler exceptionHandler = new DefaultMessagingExceptionHandler();
    private int retries = DEFAULT_RETRIES;
    private int timeout = DEFAULT_TIMEOUT;
    private int discardDataDelay = 0;
    private long lastDataTimestamp;
    private TimeSource timeSource = new SystemTimeSource();
    private final WaitingRoom waitingRoom = new WaitingRoom();
    private final ByteQueue dataBuffer = new ByteQueue();

    public void start(Transport transport, MessageParser messageParser, RequestHandler handler, WaitingRoomKeyFactory waitingRoomKeyFactory) throws IOException {
        this.transport = transport;
        this.messageParser = messageParser;
        this.requestHandler = handler;
        this.waitingRoomKeyFactory = waitingRoomKeyFactory;
        this.waitingRoom.setKeyFactory(waitingRoomKeyFactory);
        transport.setConsumer(this);
    }

    public void close() {
        this.transport.removeConsumer();
    }

    public void setExceptionHandler(MessagingExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler == null ? new DefaultMessagingExceptionHandler() : exceptionHandler;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getDiscardDataDelay() {
        return this.discardDataDelay;
    }

    public void setDiscardDataDelay(int discardDataDelay) {
        this.discardDataDelay = discardDataDelay;
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    public void setTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
    }

    public IncomingResponseMessage send(OutgoingRequestMessage request) throws IOException {
        return this.send(request, this.timeout, this.retries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncomingResponseMessage send(OutgoingRequestMessage request, int timeout, int retries) throws IOException {
        byte[] data = request.getMessageData();
        if (this.DEBUG) {
            System.out.println("MessagingControl.send: " + StreamUtils.dumpHex(data));
        }
        IncomingResponseMessage response = null;
        if (request.expectsResponse()) {
            WaitingRoomKey key = this.waitingRoomKeyFactory.createWaitingRoomKey(request);
            this.waitingRoom.enter(key);
            try {
                do {
                    this.write(data);
                    response = this.waitingRoom.getResponse(key, timeout);
                    if (!this.DEBUG || response != null) continue;
                    System.out.println("Timeout waiting for response");
                } while (response == null && retries-- > 0);
            }
            finally {
                this.waitingRoom.leave(key);
            }
            if (response == null) {
                throw new TimeoutException("request=" + request);
            }
        } else {
            this.write(data);
        }
        return response;
    }

    public void send(OutgoingResponseMessage response) throws IOException {
        this.write(response.getMessageData());
    }

    @Override
    public void data(byte[] b, int len) {
        if (this.DEBUG) {
            System.out.println("MessagingConnection.read: " + StreamUtils.dumpHex(b, 0, len));
        }
        if (this.discardDataDelay > 0) {
            long now = this.timeSource.currentTimeMillis();
            if (now - this.lastDataTimestamp > (long)this.discardDataDelay) {
                this.dataBuffer.clear();
            }
            this.lastDataTimestamp = now;
        }
        this.dataBuffer.push(b, 0, len);
        block2: while (true) {
            try {
                while (true) {
                    this.dataBuffer.mark();
                    IncomingMessage message = this.messageParser.parseMessage(this.dataBuffer);
                    if (message == null) {
                        this.dataBuffer.reset();
                        break block2;
                    }
                    if (message instanceof IncomingRequestMessage) {
                        OutgoingResponseMessage response;
                        if (this.requestHandler == null || (response = this.requestHandler.handleRequest((IncomingRequestMessage)message)) == null) continue;
                        this.send(response);
                        continue;
                    }
                    this.waitingRoom.response((IncomingResponseMessage)message);
                }
            }
            catch (Exception e) {
                this.exceptionHandler.receivedException(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(byte[] data) throws IOException {
        Transport transport = this.transport;
        synchronized (transport) {
            this.transport.write(data);
        }
    }

    @Override
    public void handleIOException(IOException e) {
        this.exceptionHandler.receivedException(e);
    }
}

