/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.serial.ascii;

import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.msg.ModbusMessage;
import com.zgkxzx.modbus4And.serial.SerialMessage;
import com.zgkxzx.modbus4And.sero.util.queue.ByteQueue;

public abstract class AsciiMessage
extends SerialMessage {
    private static final byte START = 58;
    private static final byte[] END = new byte[]{13, 10};
    private static byte[] lookupAscii = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] lookupUnascii = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    AsciiMessage(ModbusMessage modbusMessage) {
        super(modbusMessage);
    }

    protected static ByteQueue getUnasciiMessage(ByteQueue queue) throws ModbusTransportException {
        byte b = queue.pop();
        if (b != 58) {
            throw new ModbusTransportException("Invalid message start: " + b);
        }
        int end = queue.indexOf(END);
        if (end == -1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] asciiBytes = new byte[end - 2];
        queue.pop(asciiBytes);
        ByteQueue msgQueue = new ByteQueue(asciiBytes);
        byte givenLrc = AsciiMessage.readAscii(queue);
        queue.pop(END.length);
        AsciiMessage.fromAscii(msgQueue, msgQueue.size());
        byte calcLrc = AsciiMessage.calculateLRC(msgQueue, 0, msgQueue.size());
        if (calcLrc != givenLrc) {
            throw new ModbusTransportException("LRC mismatch: given=" + (givenLrc & 0xFF) + ", calc=" + (calcLrc & 0xFF));
        }
        return msgQueue;
    }

    protected byte[] getAsciiData(ByteQueue queue) {
        int unasciiLen = queue.size();
        queue.push((byte)58);
        byte lrc = AsciiMessage.calculateLRC(queue, 0, unasciiLen);
        AsciiMessage.toAscii(queue, unasciiLen);
        AsciiMessage.writeAscii(queue, lrc);
        queue.push(END);
        return queue.popAll();
    }

    public byte[] getMessageData() {
        ByteQueue queue = new ByteQueue();
        this.modbusMessage.write(queue);
        return this.getAsciiData(queue);
    }

    private static byte calculateLRC(ByteQueue queue, int start, int len) {
        int lrc = 0;
        for (int i = 0; i < len; ++i) {
            lrc -= queue.peek(i + start);
        }
        return (byte)(lrc & 0xFF);
    }

    private static void toAscii(ByteQueue queue, int unasciiLen) {
        for (int i = 0; i < unasciiLen; ++i) {
            AsciiMessage.writeAscii(queue, queue.pop());
        }
    }

    private static void writeAscii(ByteQueue to, byte b) {
        to.push(lookupAscii[b & 0xF0]);
        to.push(lookupAscii[b & 0xF]);
    }

    private static void fromAscii(ByteQueue queue, int asciiLen) {
        int len = asciiLen / 2;
        for (int i = 0; i < len; ++i) {
            queue.push(AsciiMessage.readAscii(queue));
        }
    }

    private static byte readAscii(ByteQueue from) {
        return (byte)(lookupUnascii[from.pop()] << 4 | lookupUnascii[from.pop()]);
    }
}

