/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.requset;

import android.util.Log;
import com.zgkxzx.modbus4And.ModbusFactory;
import com.zgkxzx.modbus4And.ModbusMaster;
import com.zgkxzx.modbus4And.exception.ModbusInitException;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.ip.IpParameters;
import com.zgkxzx.modbus4And.msg.ReadCoilsRequest;
import com.zgkxzx.modbus4And.msg.ReadCoilsResponse;
import com.zgkxzx.modbus4And.msg.ReadDiscreteInputsRequest;
import com.zgkxzx.modbus4And.msg.ReadDiscreteInputsResponse;
import com.zgkxzx.modbus4And.msg.ReadExceptionStatusRequest;
import com.zgkxzx.modbus4And.msg.ReadExceptionStatusResponse;
import com.zgkxzx.modbus4And.msg.ReadHoldingRegistersRequest;
import com.zgkxzx.modbus4And.msg.ReadHoldingRegistersResponse;
import com.zgkxzx.modbus4And.msg.ReadInputRegistersRequest;
import com.zgkxzx.modbus4And.msg.ReadInputRegistersResponse;
import com.zgkxzx.modbus4And.msg.ReportSlaveIdRequest;
import com.zgkxzx.modbus4And.msg.ReportSlaveIdResponse;
import com.zgkxzx.modbus4And.msg.WriteCoilRequest;
import com.zgkxzx.modbus4And.msg.WriteCoilResponse;
import com.zgkxzx.modbus4And.msg.WriteCoilsRequest;
import com.zgkxzx.modbus4And.msg.WriteCoilsResponse;
import com.zgkxzx.modbus4And.msg.WriteMaskRegisterRequest;
import com.zgkxzx.modbus4And.msg.WriteMaskRegisterResponse;
import com.zgkxzx.modbus4And.msg.WriteRegisterRequest;
import com.zgkxzx.modbus4And.msg.WriteRegisterResponse;
import com.zgkxzx.modbus4And.msg.WriteRegistersRequest;
import com.zgkxzx.modbus4And.msg.WriteRegistersResponse;
import com.zgkxzx.modbus4And.requset.ModbusParam;
import com.zgkxzx.modbus4And.requset.OnRequestBack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ModbusReq {
    private static final String TAG = ModbusReq.class.getSimpleName();
    private static ModbusReq modbusReq;
    private ModbusMaster mModbusMaster;
    private ModbusParam modbusParam = new ModbusParam();
    ExecutorService executorService = Executors.newFixedThreadPool(1);
    private boolean isInit = false;

    private ModbusReq() {
    }

    public static synchronized ModbusReq getInstance() {
        if (modbusReq == null) {
            modbusReq = new ModbusReq();
        }
        return modbusReq;
    }

    public ModbusReq setParam(ModbusParam modbusParam) {
        this.modbusParam = modbusParam;
        return modbusReq;
    }

    public void init(final OnRequestBack<String> onRequestBack) {
        ModbusFactory mModbusFactory = new ModbusFactory();
        IpParameters params = new IpParameters();
        params.setHost(this.modbusParam.host);
        params.setPort(this.modbusParam.port);
        params.setEncapsulated(this.modbusParam.encapsulated);
        this.mModbusMaster = mModbusFactory.createTcpMaster(params, this.modbusParam.keepAlive);
        this.mModbusMaster.setRetries(this.modbusParam.retries);
        this.mModbusMaster.setTimeout(this.modbusParam.timeout);
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ModbusReq.this.mModbusMaster.init();
                }
                catch (ModbusInitException e) {
                    ModbusReq.this.mModbusMaster.destroy();
                    ModbusReq.this.isInit = false;
                    Log.d((String)TAG, (String)("Modbus4Android init failed " + e));
                    onRequestBack.onFailed("Modbus4Android init failed ");
                    return;
                }
                Log.d((String)TAG, (String)"Modbus4Android init success");
                ModbusReq.this.isInit = true;
                onRequestBack.onSuccess("Modbus4Android init success");
            }
        });
    }

    public void destory() {
        modbusReq = null;
        this.mModbusMaster.destroy();
        this.isInit = false;
    }

    public void readCoil(final OnRequestBack<boolean[]> onRequestBack, final int slaveId, final int start, final int len) {
        if (!this.isInit) {
            onRequestBack.onFailed("Modbus master is not inited successfully...");
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ReadCoilsRequest request = new ReadCoilsRequest(slaveId, start, len);
                    ReadCoilsResponse response = (ReadCoilsResponse)ModbusReq.this.mModbusMaster.send(request);
                    if (response.isException()) {
                        onRequestBack.onFailed(response.getExceptionMessage());
                    } else {
                        boolean[] booleanData = response.getBooleanData();
                        boolean[] resultByte = new boolean[len];
                        System.arraycopy(booleanData, 0, resultByte, 0, len);
                        onRequestBack.onSuccess(resultByte);
                    }
                }
                catch (ModbusTransportException e) {
                    e.printStackTrace();
                    onRequestBack.onFailed(e.toString());
                }
            }
        });
    }

    public void readDiscreteInput(final OnRequestBack<boolean[]> onRequestBack, final int slaveId, final int start, final int len) {
        if (!this.isInit) {
            onRequestBack.onFailed("Modbus master is not inited successfully...");
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ReadDiscreteInputsRequest request = new ReadDiscreteInputsRequest(slaveId, start, len);
                    ReadDiscreteInputsResponse response = (ReadDiscreteInputsResponse)ModbusReq.this.mModbusMaster.send(request);
                    if (response.isException()) {
                        onRequestBack.onFailed(response.getExceptionMessage());
                    } else {
                        boolean[] booleanData = response.getBooleanData();
                        boolean[] resultByte = new boolean[len];
                        System.arraycopy(booleanData, 0, resultByte, 0, len);
                        onRequestBack.onSuccess(resultByte);
                    }
                }
                catch (ModbusTransportException e) {
                    e.printStackTrace();
                    onRequestBack.onFailed(e.toString());
                }
            }
        });
    }

    public void readHoldingRegisters(final OnRequestBack<short[]> onRequestBack, final int slaveId, final int start, final int len) {
        if (!this.isInit) {
            onRequestBack.onFailed("Modbus master is not inited successfully...");
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ReadHoldingRegistersRequest request = new ReadHoldingRegistersRequest(slaveId, start, len);
                    ReadHoldingRegistersResponse response = (ReadHoldingRegistersResponse)ModbusReq.this.mModbusMaster.send(request);
                    if (response.isException()) {
                        onRequestBack.onFailed(response.getExceptionMessage());
                    } else {
                        onRequestBack.onSuccess(response.getShortData());
                    }
                }
                catch (ModbusTransportException e) {
                    e.printStackTrace();
                    onRequestBack.onFailed(e.toString());
                }
            }
        });
    }

    public void readInputRegisters(final OnRequestBack<short[]> onRequestBack, final int slaveId, final int start, final int len) {
        if (!this.isInit) {
            onRequestBack.onFailed("Modbus master is not inited successfully...");
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ReadInputRegistersRequest request = new ReadInputRegistersRequest(slaveId, start, len);
                    ReadInputRegistersResponse response = (ReadInputRegistersResponse)ModbusReq.this.mModbusMaster.send(request);
                    if (response.isException()) {
                        onRequestBack.onFailed(response.getExceptionMessage());
                    } else {
                        onRequestBack.onSuccess(response.getShortData());
                    }
                }
                catch (ModbusTransportException e) {
                    e.printStackTrace();
                    onRequestBack.onFailed(e.toString());
                }
            }
        });
    }

    public void writeCoil(final OnRequestBack<String> onRequestBack, final int slaveId, final int offset, final boolean value) {
        if (!this.isInit) {
            onRequestBack.onFailed("Modbus master is not inited successfully...");
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    WriteCoilRequest request = new WriteCoilRequest(slaveId, offset, value);
                    WriteCoilResponse response = (WriteCoilResponse)ModbusReq.this.mModbusMaster.send(request);
                    if (response.isException()) {
                        onRequestBack.onFailed(response.getExceptionMessage());
                    } else {
                        onRequestBack.onSuccess("Success");
                    }
                }
                catch (ModbusTransportException e) {
                    e.printStackTrace();
                    onRequestBack.onFailed(e.toString());
                }
            }
        });
    }

    public void writeCoils(final OnRequestBack<String> onRequestBack, final int slaveId, final int start, final boolean[] values) {
        if (!this.isInit) {
            onRequestBack.onFailed("Modbus master is not inited successfully...");
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    WriteCoilsRequest request = new WriteCoilsRequest(slaveId, start, values);
                    WriteCoilsResponse response = (WriteCoilsResponse)ModbusReq.this.mModbusMaster.send(request);
                    if (response.isException()) {
                        onRequestBack.onFailed(response.getExceptionMessage());
                    } else {
                        onRequestBack.onSuccess("Success");
                    }
                }
                catch (ModbusTransportException e) {
                    e.printStackTrace();
                    onRequestBack.onFailed(e.toString());
                }
            }
        });
    }

    public void writeRegister(final OnRequestBack<String> onRequestBack, final int slaveId, final int offset, final int value) {
        if (!this.isInit) {
            onRequestBack.onFailed("Modbus master is not inited successfully...");
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    WriteRegisterRequest request = new WriteRegisterRequest(slaveId, offset, value);
                    WriteRegisterResponse response = (WriteRegisterResponse)ModbusReq.this.mModbusMaster.send(request);
                    if (response.isException()) {
                        onRequestBack.onFailed(response.getExceptionMessage());
                    } else {
                        onRequestBack.onSuccess("Success");
                    }
                }
                catch (ModbusTransportException e) {
                    e.printStackTrace();
                    onRequestBack.onFailed(e.toString());
                }
            }
        });
    }

    public void writeRegisters(final OnRequestBack<String> onRequestBack, final int slaveId, final int start, final short[] values) {
        if (!this.isInit) {
            onRequestBack.onFailed("Modbus master is not inited successfully...");
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    WriteRegistersRequest request = new WriteRegistersRequest(slaveId, start, values);
                    WriteRegistersResponse response = (WriteRegistersResponse)ModbusReq.this.mModbusMaster.send(request);
                    if (response.isException()) {
                        onRequestBack.onFailed(response.getExceptionMessage());
                    } else {
                        onRequestBack.onSuccess("Success");
                    }
                }
                catch (ModbusTransportException e) {
                    e.printStackTrace();
                    onRequestBack.onFailed(e.toString());
                }
            }
        });
    }

    public void readExceptionStatus(final OnRequestBack<Byte> onRequestBack, final int slaveId) {
        if (!this.isInit) {
            onRequestBack.onFailed("Modbus master is not inited successfully...");
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ReadExceptionStatusRequest request = new ReadExceptionStatusRequest(slaveId);
                    ReadExceptionStatusResponse response = (ReadExceptionStatusResponse)ModbusReq.this.mModbusMaster.send(request);
                    if (response.isException()) {
                        onRequestBack.onFailed(response.getExceptionMessage());
                    } else {
                        onRequestBack.onSuccess(response.getExceptionStatus());
                    }
                }
                catch (ModbusTransportException e) {
                    e.printStackTrace();
                    onRequestBack.onFailed(e.toString());
                }
            }
        });
    }

    public void reportSlaveId(final OnRequestBack<byte[]> onRequestBack, final int slaveId) {
        if (!this.isInit) {
            onRequestBack.onFailed("Modbus master is not inited successfully...");
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ReportSlaveIdRequest request = new ReportSlaveIdRequest(slaveId);
                    ReportSlaveIdResponse response = (ReportSlaveIdResponse)ModbusReq.this.mModbusMaster.send(request);
                    if (response.isException()) {
                        onRequestBack.onFailed(response.getExceptionMessage());
                    } else {
                        onRequestBack.onSuccess(response.getData());
                    }
                }
                catch (ModbusTransportException e) {
                    e.printStackTrace();
                    onRequestBack.onFailed(e.toString());
                }
            }
        });
    }

    public void writeMaskRegister(final OnRequestBack<String> onRequestBack, final int slaveId, final int offset, final int and, final int or) {
        if (!this.isInit) {
            onRequestBack.onFailed("Modbus master is not inited successfully...");
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    WriteMaskRegisterRequest request = new WriteMaskRegisterRequest(slaveId, offset, and, or);
                    WriteMaskRegisterResponse response = (WriteMaskRegisterResponse)ModbusReq.this.mModbusMaster.send(request);
                    if (response.isException()) {
                        onRequestBack.onFailed(response.getExceptionMessage());
                    } else {
                        onRequestBack.onSuccess("Success");
                    }
                }
                catch (ModbusTransportException e) {
                    e.printStackTrace();
                    onRequestBack.onFailed(e.toString());
                }
            }
        });
    }
}

