/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.msg;

import com.zgkxzx.modbus4And.base.ModbusUtils;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.msg.ModbusResponse;
import com.zgkxzx.modbus4And.sero.util.queue.ByteQueue;

public class WriteMaskRegisterResponse
extends ModbusResponse {
    private int writeOffset;
    private int andMask;
    private int orMask;

    @Override
    public byte getFunctionCode() {
        return 22;
    }

    WriteMaskRegisterResponse(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    WriteMaskRegisterResponse(int slaveId, int writeOffset, int andMask, int orMask) throws ModbusTransportException {
        super(slaveId);
        this.writeOffset = writeOffset;
        this.andMask = andMask;
        this.orMask = orMask;
    }

    @Override
    protected void writeResponse(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.writeOffset);
        ModbusUtils.pushShort(queue, this.andMask);
        ModbusUtils.pushShort(queue, this.orMask);
    }

    @Override
    protected void readResponse(ByteQueue queue) {
        this.writeOffset = ModbusUtils.popUnsignedShort(queue);
        this.andMask = ModbusUtils.popUnsignedShort(queue);
        this.orMask = ModbusUtils.popUnsignedShort(queue);
    }

    public int getWriteOffset() {
        return this.writeOffset;
    }

    public int getAndMask() {
        return this.andMask;
    }

    public int getOrMask() {
        return this.orMask;
    }
}

