/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.msg;

import com.zgkxzx.modbus4And.base.ModbusUtils;
import com.zgkxzx.modbus4And.code.ExceptionCode;
import com.zgkxzx.modbus4And.exception.IllegalFunctionException;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.msg.ModbusMessage;
import com.zgkxzx.modbus4And.msg.ReadCoilsResponse;
import com.zgkxzx.modbus4And.msg.ReadDiscreteInputsResponse;
import com.zgkxzx.modbus4And.msg.ReadExceptionStatusResponse;
import com.zgkxzx.modbus4And.msg.ReadHoldingRegistersResponse;
import com.zgkxzx.modbus4And.msg.ReadInputRegistersResponse;
import com.zgkxzx.modbus4And.msg.ReportSlaveIdResponse;
import com.zgkxzx.modbus4And.msg.WriteCoilResponse;
import com.zgkxzx.modbus4And.msg.WriteCoilsResponse;
import com.zgkxzx.modbus4And.msg.WriteMaskRegisterResponse;
import com.zgkxzx.modbus4And.msg.WriteRegisterResponse;
import com.zgkxzx.modbus4And.msg.WriteRegistersResponse;
import com.zgkxzx.modbus4And.sero.util.queue.ByteQueue;

public abstract class ModbusResponse
extends ModbusMessage {
    protected static final byte MAX_FUNCTION_CODE = -128;
    protected byte exceptionCode = (byte)-1;

    public static ModbusResponse createModbusResponse(ByteQueue queue) throws ModbusTransportException {
        int slaveId = ModbusUtils.popUnsignedByte(queue);
        byte functionCode = queue.pop();
        boolean isException = false;
        if (ModbusResponse.greaterThan(functionCode, (byte)-128)) {
            isException = true;
            functionCode = (byte)(functionCode + 128);
        }
        ModbusResponse response = null;
        if (functionCode == 1) {
            response = new ReadCoilsResponse(slaveId);
        } else if (functionCode == 2) {
            response = new ReadDiscreteInputsResponse(slaveId);
        } else if (functionCode == 3) {
            response = new ReadHoldingRegistersResponse(slaveId);
        } else if (functionCode == 4) {
            response = new ReadInputRegistersResponse(slaveId);
        } else if (functionCode == 5) {
            response = new WriteCoilResponse(slaveId);
        } else if (functionCode == 6) {
            response = new WriteRegisterResponse(slaveId);
        } else if (functionCode == 7) {
            response = new ReadExceptionStatusResponse(slaveId);
        } else if (functionCode == 15) {
            response = new WriteCoilsResponse(slaveId);
        } else if (functionCode == 16) {
            response = new WriteRegistersResponse(slaveId);
        } else if (functionCode == 17) {
            response = new ReportSlaveIdResponse(slaveId);
        } else if (functionCode == 22) {
            response = new WriteMaskRegisterResponse(slaveId);
        } else {
            throw new IllegalFunctionException(functionCode, slaveId);
        }
        response.read(queue, isException);
        return response;
    }

    ModbusResponse(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    public boolean isException() {
        return this.exceptionCode != -1;
    }

    public String getExceptionMessage() {
        return ExceptionCode.getExceptionMessage(this.exceptionCode);
    }

    void setException(byte exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    public byte getExceptionCode() {
        return this.exceptionCode;
    }

    @Override
    protected final void writeImpl(ByteQueue queue) {
        if (this.isException()) {
            queue.push((byte)(this.getFunctionCode() + -128));
            queue.push(this.exceptionCode);
        } else {
            queue.push(this.getFunctionCode());
            this.writeResponse(queue);
        }
    }

    protected abstract void writeResponse(ByteQueue var1);

    void read(ByteQueue queue, boolean isException) {
        if (isException) {
            this.exceptionCode = queue.pop();
        } else {
            this.readResponse(queue);
        }
    }

    protected abstract void readResponse(ByteQueue var1);

    private static boolean greaterThan(byte b1, byte b2) {
        int i1 = b1 & 0xFF;
        int i2 = b2 & 0xFF;
        return i1 > i2;
    }

    public static void main(String[] args) throws Exception {
        ByteQueue queue = new ByteQueue(new byte[]{3, 2});
        ModbusResponse r = ModbusResponse.createModbusResponse(queue);
        System.out.println(r);
    }
}

