/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.locator;

import com.zgkxzx.modbus4And.exception.IllegalDataTypeException;
import com.zgkxzx.modbus4And.locator.BaseLocator;
import java.nio.charset.Charset;

public class StringLocator
extends BaseLocator<String> {
    public static final Charset ASCII = Charset.forName("ASCII");
    private final int dataType;
    private final int registerCount;
    private final Charset charset;

    public StringLocator(int slaveId, int range, int offset, int dataType, int registerCount) {
        this(slaveId, range, offset, dataType, registerCount, ASCII);
    }

    public StringLocator(int slaveId, int range, int offset, int dataType, int registerCount, Charset charset) {
        super(slaveId, range, offset);
        this.dataType = dataType;
        this.registerCount = registerCount;
        this.charset = charset;
        this.validate();
    }

    private void validate() {
        super.validate(this.registerCount);
        if (this.range == 1 || this.range == 2) {
            throw new IllegalDataTypeException("Only binary values can be read from Coil and Input ranges");
        }
        if (this.dataType != 18 && this.dataType != 19) {
            throw new IllegalDataTypeException("Invalid data type");
        }
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    public String toString() {
        return "StringLocator(slaveId=" + this.getSlaveId() + ", range=" + this.range + ", offset=" + this.offset + ", dataType=" + this.dataType + ", registerCount=" + this.registerCount + ", charset=" + this.charset + ")";
    }

    @Override
    public String bytesToValueRealOffset(byte[] data, int offset) {
        offset *= 2;
        int length = this.registerCount * 2;
        if (this.dataType == 18) {
            return new String(data, offset, length, this.charset);
        }
        if (this.dataType == 19) {
            int nullPos = -1;
            for (int i = offset; i < offset + length; ++i) {
                if (data[i] != 0) continue;
                nullPos = i;
                break;
            }
            if (nullPos == -1) {
                return new String(data, offset, length, this.charset);
            }
            return new String(data, offset, nullPos, this.charset);
        }
        throw new RuntimeException("Unsupported data type: " + this.dataType);
    }

    @Override
    public short[] valueToShorts(String value) {
        int length;
        short[] result = new short[this.registerCount];
        int resultByteLen = this.registerCount * 2;
        if (value != null) {
            length = resultByteLen;
            byte[] bytes = value.getBytes(this.charset);
            if (length > bytes.length) {
                length = bytes.length;
            }
            for (int i = 0; i < length; ++i) {
                this.setByte(result, i, bytes[i] & 0xFF);
            }
        } else {
            length = 0;
        }
        if (this.dataType == 18) {
            for (int i = length; i < resultByteLen; ++i) {
                this.setByte(result, i, 32);
            }
        } else if (this.dataType == 19) {
            if (length >= resultByteLen) {
                int n = this.registerCount - 1;
                result[n] = (short)(result[n] & 0xFF00);
            } else {
                for (int i = length; i < resultByteLen; ++i) {
                    this.setByte(result, i, 0);
                }
            }
        } else {
            throw new RuntimeException("Unsupported data type: " + this.dataType);
        }
        return result;
    }

    private void setByte(short[] s, int byteIndex, int value) {
        if (byteIndex % 2 == 0) {
            int n = byteIndex / 2;
            s[n] = (short)(s[n] | value << 8);
        } else {
            int n = byteIndex / 2;
            s[n] = (short)(s[n] | value);
        }
    }
}

