/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.website;

import com.yanzhenjie.andserver.exception.NotFoundException;
import com.yanzhenjie.andserver.protocol.ETag;
import com.yanzhenjie.andserver.protocol.LastModified;
import com.yanzhenjie.andserver.util.FileUtils;
import com.yanzhenjie.andserver.util.HttpRequestParser;
import com.yanzhenjie.andserver.view.View;
import com.yanzhenjie.andserver.website.SimpleWebsite;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.httpcore.HttpEntity;
import org.apache.httpcore.HttpException;
import org.apache.httpcore.HttpRequest;
import org.apache.httpcore.entity.ContentType;
import org.apache.httpcore.entity.FileEntity;
import org.apache.httpcore.protocol.HttpContext;

public class StorageWebsite
extends SimpleWebsite
implements LastModified,
ETag {
    private final String mRootPath;

    public StorageWebsite(String rootPath) {
        this.mRootPath = rootPath;
    }

    @Override
    public boolean intercept(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String httpPath = HttpRequestParser.getRequestPath(request);
        httpPath = "/".equals(httpPath) ? "/" : this.trimEndSlash(HttpRequestParser.getRequestPath(request));
        File source = this.findPathSource(httpPath);
        return source != null;
    }

    private File findPathSource(String httpPath) {
        if ("/".equals(httpPath)) {
            File indexFile = new File(this.mRootPath, "/index.html");
            if (indexFile.exists() && indexFile.isFile()) {
                return indexFile;
            }
        } else {
            File sourceFile = new File(this.mRootPath, httpPath);
            if (sourceFile.exists()) {
                if (sourceFile.isFile()) {
                    return sourceFile;
                }
                File childIndexFile = new File(sourceFile, "/index.html");
                if (childIndexFile.exists() && childIndexFile.isFile()) {
                    return childIndexFile;
                }
            }
        }
        return null;
    }

    @Override
    public View handle(HttpRequest request) throws HttpException, IOException {
        String httpPath = this.trimEndSlash(HttpRequestParser.getRequestPath(request));
        File source = this.findPathSource(httpPath);
        if (source == null) {
            throw new NotFoundException(httpPath);
        }
        return this.generateSourceView(source);
    }

    private View generateSourceView(File source) throws IOException {
        String mimeType = FileUtils.getMimeType(source.getAbsolutePath());
        FileEntity httpEntity = new FileEntity(source, ContentType.create((String)mimeType, (Charset)Charset.defaultCharset()));
        return new View(200, (HttpEntity)httpEntity);
    }

    @Override
    public long getLastModified(HttpRequest request) throws IOException {
        String httpPath = this.trimEndSlash(HttpRequestParser.getRequestPath(request));
        File source = this.findPathSource(httpPath);
        if (source != null) {
            return source.lastModified();
        }
        return -1L;
    }

    @Override
    public String getETag(HttpRequest request) throws IOException {
        String httpPath = this.trimEndSlash(HttpRequestParser.getRequestPath(request));
        File source = this.findPathSource(httpPath);
        if (source != null) {
            long sourceSize = source.length();
            String sourcePath = source.getAbsolutePath();
            long lastModified = source.lastModified();
            return sourceSize + sourcePath + lastModified;
        }
        return null;
    }
}

