/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.util;

import android.content.res.AssetManager;
import android.text.TextUtils;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class AssetsReader {
    private AssetManager mAssetManager;

    public AssetsReader(AssetManager assetManager) {
        this.mAssetManager = assetManager;
    }

    public InputStream getInputStream(String fileName) {
        try {
            return this.mAssetManager.open(fileName);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public boolean isFile(String fileName) {
        return this.getInputStream(fileName) != null;
    }

    public String[] fileList(String path) {
        try {
            return this.mAssetManager.list(path);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public List<String> scanFile(String inPath) {
        LinkedList<String> pathList = new LinkedList<String>();
        if (this.isFile(inPath)) {
            pathList.add(inPath);
        } else {
            String[] files = this.fileList(inPath);
            if (files != null && files.length > 0) {
                for (String file : files) {
                    String realPath = (TextUtils.isEmpty((CharSequence)inPath) ? "" : inPath + File.separator) + file;
                    if (this.isFile(realPath)) {
                        pathList.add(realPath);
                        continue;
                    }
                    List<String> childList = this.scanFile(realPath);
                    if (childList.size() <= 0) continue;
                    pathList.addAll(childList);
                }
            }
        }
        return pathList;
    }
}

