/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.exception.resolver;

import com.yanzhenjie.andserver.exception.BaseException;
import com.yanzhenjie.andserver.exception.resolver.ExceptionResolver;
import com.yanzhenjie.andserver.view.View;
import org.apache.httpcore.HttpEntity;
import org.apache.httpcore.HttpRequest;
import org.apache.httpcore.HttpResponse;
import org.apache.httpcore.entity.ContentType;
import org.apache.httpcore.entity.StringEntity;
import org.apache.httpcore.protocol.HttpContext;

public class SimpleExceptionResolver
implements ExceptionResolver {
    @Override
    public final void resolveException(Exception e, HttpRequest request, HttpResponse response, HttpContext context) {
        View view = this.resolveException(e, request, response);
        response.setStatusCode(view.getHttpCode());
        response.setEntity(view.getHttpEntity());
        response.setHeaders(view.getHeaders());
    }

    public View resolveException(Exception e, HttpRequest request, HttpResponse response) {
        return this.resolveException(e);
    }

    protected View resolveException(Exception e) {
        if (e instanceof BaseException) {
            BaseException exception = (BaseException)((Object)e);
            return new View(exception.getHttpCode(), exception.getHttpBody());
        }
        String message = String.format("Server error occurred:\n%1$s", e.getMessage());
        StringEntity httpEntity = new StringEntity(message, ContentType.TEXT_PLAIN);
        return new View(500, (HttpEntity)httpEntity);
    }
}

