/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver;

import com.yanzhenjie.andserver.RequestHandler;
import com.yanzhenjie.andserver.exception.resolver.ExceptionResolver;
import com.yanzhenjie.andserver.filter.Filter;
import com.yanzhenjie.andserver.interceptor.Interceptor;
import com.yanzhenjie.andserver.ssl.SSLSocketInitializer;
import com.yanzhenjie.andserver.website.WebSite;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;

public interface Server {
    public boolean isRunning();

    public void startup();

    public InetAddress getInetAddress();

    public void shutdown();

    public static interface ServerListener {
        public void onStarted();

        public void onStopped();

        public void onError(Exception var1);
    }

    public static interface Builder {
        public Builder inetAddress(InetAddress var1);

        public Builder port(int var1);

        public Builder timeout(int var1, TimeUnit var2);

        public Builder sslContext(SSLContext var1);

        public Builder sslSocketInitializer(SSLSocketInitializer var1);

        public Builder interceptor(Interceptor var1);

        public Builder website(WebSite var1);

        public Builder registerHandler(String var1, RequestHandler var2);

        public Builder filter(Filter var1);

        public Builder exceptionResolver(ExceptionResolver var1);

        public Builder listener(ServerListener var1);

        public Server build();
    }
}

