/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver;

import android.text.TextUtils;
import java.util.Locale;

public enum RequestMethod {
    GET("GET"),
    HEAD("HEAD"),
    POST("POST"),
    PUT("PUT"),
    PATCH("PATCH"),
    DELETE("DELETE"),
    OPTIONS("OPTIONS"),
    TRACE("TRACE");

    private String method;

    private RequestMethod(String method) {
        this.method = method;
    }

    public String getValue() {
        return this.method;
    }

    public boolean allowRequestBody() {
        switch (this) {
            case POST: 
            case PUT: 
            case PATCH: 
            case DELETE: {
                return true;
            }
        }
        return false;
    }

    public static RequestMethod reverse(String method) {
        if (TextUtils.isEmpty((CharSequence)method)) {
            return GET;
        }
        switch (method = method.toUpperCase(Locale.ENGLISH)) {
            case "GET": {
                return GET;
            }
            case "HEAD": {
                return HEAD;
            }
            case "POST": {
                return POST;
            }
            case "PUT": {
                return PUT;
            }
            case "PATCH": {
                return PATCH;
            }
            case "DELETE": {
                return DELETE;
            }
            case "OPTIONS": {
                return OPTIONS;
            }
            case "TRACE": {
                return TRACE;
            }
        }
        return GET;
    }
}

