/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver;

import com.yanzhenjie.andserver.DispatchRequestHandler;
import com.yanzhenjie.andserver.RequestHandler;
import com.yanzhenjie.andserver.Server;
import com.yanzhenjie.andserver.exception.resolver.ExceptionResolver;
import com.yanzhenjie.andserver.filter.Filter;
import com.yanzhenjie.andserver.interceptor.Interceptor;
import com.yanzhenjie.andserver.ssl.SSLSocketInitializer;
import com.yanzhenjie.andserver.util.Executors;
import com.yanzhenjie.andserver.website.WebSite;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.httpcore.ExceptionLogger;
import org.apache.httpcore.config.ConnectionConfig;
import org.apache.httpcore.config.SocketConfig;
import org.apache.httpcore.impl.bootstrap.HttpServer;
import org.apache.httpcore.impl.bootstrap.SSLServerSetupHandler;
import org.apache.httpcore.impl.bootstrap.ServerBootstrap;
import org.apache.httpcore.protocol.HttpRequestHandler;

final class Core
implements Server {
    private final InetAddress mInetAddress;
    private final int mPort;
    private final int mTimeout;
    private final SSLContext mSSLContext;
    private final SSLSocketInitializer mSSLSocketInitializer;
    private final Interceptor mInterceptor;
    private final WebSite mWebSite;
    private final Map<String, RequestHandler> mRequestHandlerMap;
    private final Filter mFilter;
    private final ExceptionResolver mExceptionResolver;
    private final Server.ServerListener mListener;
    private HttpServer mHttpServer;
    private boolean isRunning;

    static Builder newBuilder() {
        return new Builder();
    }

    private Core(Builder builder) {
        this.mInetAddress = builder.mInetAddress;
        this.mPort = builder.mPort;
        this.mTimeout = builder.mTimeout;
        this.mSSLContext = builder.mSSLContext;
        this.mSSLSocketInitializer = builder.mSSLSocketInitializer;
        this.mInterceptor = builder.mInterceptor;
        this.mWebSite = builder.mWebSite;
        this.mRequestHandlerMap = builder.mRequestHandlerMap;
        this.mFilter = builder.mFilter;
        this.mExceptionResolver = builder.mExceptionResolver;
        this.mListener = builder.mListener;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void startup() {
        if (this.isRunning) {
            return;
        }
        Executors.getInstance().submit(new Runnable(){

            @Override
            public void run() {
                DispatchRequestHandler handler = new DispatchRequestHandler();
                handler.setInterceptor(Core.this.mInterceptor);
                handler.setWebSite(Core.this.mWebSite);
                if (Core.this.mRequestHandlerMap != null && Core.this.mRequestHandlerMap.size() > 0) {
                    for (Map.Entry handlerEntry : Core.this.mRequestHandlerMap.entrySet()) {
                        String path = (String)handlerEntry.getKey();
                        RequestHandler requestHandler = (RequestHandler)handlerEntry.getValue();
                        handler.registerRequestHandler(path, requestHandler);
                    }
                }
                handler.setFilter(Core.this.mFilter);
                handler.setExceptionResolver(Core.this.mExceptionResolver);
                Core.this.mHttpServer = ServerBootstrap.bootstrap().setSocketConfig(SocketConfig.custom().setSoKeepAlive(true).setSoReuseAddress(false).setSoTimeout(Core.this.mTimeout).setTcpNoDelay(false).build()).setConnectionConfig(ConnectionConfig.custom().setBufferSize(4096).setCharset(Charset.defaultCharset()).build()).setLocalAddress(Core.this.mInetAddress).setListenerPort(Core.this.mPort).setSslContext(Core.this.mSSLContext).setSslSetupHandler((SSLServerSetupHandler)new SSLSocketInitializer.SSLSocketInitializerWrapper(Core.this.mSSLSocketInitializer)).setServerInfo("AndServer").registerHandler("*", (HttpRequestHandler)handler).setExceptionLogger(ExceptionLogger.STD_ERR).create();
                try {
                    Core.this.isRunning = true;
                    Core.this.mHttpServer.start();
                    Executors.getInstance().post(new Runnable(){

                        @Override
                        public void run() {
                            if (Core.this.mListener != null) {
                                Core.this.mListener.onStarted();
                            }
                        }
                    });
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            Core.this.mHttpServer.shutdown(3L, TimeUnit.SECONDS);
                        }
                    });
                }
                catch (Exception e) {
                    Executors.getInstance().post(new Runnable(){

                        @Override
                        public void run() {
                            if (Core.this.mListener != null) {
                                Core.this.mListener.onError(e);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.isRunning) {
            return this.mHttpServer.getInetAddress();
        }
        return null;
    }

    @Override
    public void shutdown() {
        if (!this.isRunning) {
            return;
        }
        Executors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (Core.this.mHttpServer != null) {
                    Core.this.mHttpServer.shutdown(3L, TimeUnit.MINUTES);
                }
                Executors.getInstance().post(new Runnable(){

                    @Override
                    public void run() {
                        if (Core.this.mListener != null) {
                            Core.this.mListener.onStopped();
                        }
                    }
                });
            }
        });
    }

    private static final class Builder
    implements Server.Builder {
        private InetAddress mInetAddress;
        private int mPort;
        private int mTimeout;
        private SSLContext mSSLContext;
        private SSLSocketInitializer mSSLSocketInitializer;
        private Interceptor mInterceptor;
        private WebSite mWebSite;
        private Map<String, RequestHandler> mRequestHandlerMap = new LinkedHashMap<String, RequestHandler>();
        private Filter mFilter;
        private ExceptionResolver mExceptionResolver;
        private Server.ServerListener mListener;

        private Builder() {
        }

        @Override
        public Server.Builder inetAddress(InetAddress inetAddress) {
            this.mInetAddress = inetAddress;
            return this;
        }

        @Override
        public Server.Builder port(int port) {
            this.mPort = port;
            return this;
        }

        @Override
        public Server.Builder timeout(int timeout, TimeUnit timeUnit) {
            long timeoutMs = timeUnit.toMillis(timeout);
            this.mTimeout = (int)Math.min(timeoutMs, Integer.MAX_VALUE);
            return this;
        }

        @Override
        public Server.Builder sslContext(SSLContext sslContext) {
            this.mSSLContext = sslContext;
            return this;
        }

        @Override
        public Server.Builder sslSocketInitializer(SSLSocketInitializer initializer) {
            this.mSSLSocketInitializer = initializer;
            return this;
        }

        @Override
        public Server.Builder interceptor(Interceptor interceptor) {
            this.mInterceptor = interceptor;
            return this;
        }

        @Override
        public Server.Builder exceptionResolver(ExceptionResolver resolver) {
            this.mExceptionResolver = resolver;
            return this;
        }

        @Override
        public Server.Builder registerHandler(String path, RequestHandler handler) {
            this.mRequestHandlerMap.put(path, handler);
            return this;
        }

        @Override
        public Server.Builder filter(Filter filter) {
            this.mFilter = filter;
            return this;
        }

        @Override
        public Server.Builder website(WebSite webSite) {
            this.mWebSite = webSite;
            return this;
        }

        @Override
        public Server.Builder listener(Server.ServerListener listener) {
            this.mListener = listener;
            return this;
        }

        @Override
        public Server build() {
            return new Core(this);
        }
    }
}

