/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.wheel;

import com.ab.view.wheel.AbWheelAdapter;

public class AbNumericWheelAdapter
implements AbWheelAdapter {
    public static final int DEFAULT_MAX_VALUE = 9;
    private static final int DEFAULT_MIN_VALUE = 0;
    private int minValue;
    private int maxValue;
    private String format;

    public AbNumericWheelAdapter() {
        this(0, 9);
    }

    public AbNumericWheelAdapter(int minValue, int maxValue) {
        this(minValue, maxValue, null);
    }

    public AbNumericWheelAdapter(int minValue, int maxValue, String format) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.format = format;
    }

    @Override
    public String getItem(int index) {
        if (index >= 0 && index < this.getItemsCount()) {
            int value = this.minValue + index;
            return this.format != null ? String.format(this.format, value) : Integer.toString(value);
        }
        return null;
    }

    @Override
    public int getItemsCount() {
        return this.maxValue - this.minValue + 1;
    }

    @Override
    public int getMaximumLength() {
        int max = Math.max(Math.abs(this.maxValue), Math.abs(this.minValue));
        int maxLen = Integer.toString(max).length();
        if (this.minValue < 0) {
            ++maxLen;
        }
        return maxLen;
    }
}

