/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.pullview;

import android.content.Context;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import com.ab.util.AbLogUtil;
import com.ab.view.pullview.AbMultiColumnListAdapter;
import com.ab.view.pullview.AbViewInfo;
import java.util.ArrayList;
import java.util.List;

public class AbMultiColumnListView
extends ScrollView {
    private int columnWidth;
    private int firstColumnHeight;
    private int secondColumnHeight;
    private int thirdColumnHeight;
    private boolean loadOnce;
    private static int scrollViewHeight;
    private LinearLayout firstColumn;
    private LinearLayout secondColumn;
    private LinearLayout thirdColumn;
    private LinearLayout scrollLayout;
    private AbMultiColumnListAdapter mAdapter = null;
    private AdapterDataSetObserver mDataSetObserver;
    private List<AbViewInfo> mItems = null;
    private OnScrollListener mOnScrollListener = null;
    private int[] mReleaseImageResIds;

    public AbMultiColumnListView(Context context) {
        this(context, null);
    }

    public AbMultiColumnListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AbMultiColumnListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.scrollLayout = new LinearLayout(context);
        this.scrollLayout.setOrientation(0);
        this.firstColumn = new LinearLayout(context);
        this.firstColumn.setOrientation(1);
        this.secondColumn = new LinearLayout(context);
        this.secondColumn.setOrientation(1);
        this.thirdColumn = new LinearLayout(context);
        this.thirdColumn.setOrientation(1);
        this.scrollLayout.addView((View)this.firstColumn, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.scrollLayout.addView((View)this.secondColumn, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.scrollLayout.addView((View)this.thirdColumn, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.addView((View)this.scrollLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mItems = new ArrayList<AbViewInfo>();
    }

    public AbMultiColumnListAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(AbMultiColumnListAdapter adapter) {
        this.mAdapter = adapter;
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        if (this.mAdapter != null) {
            this.mDataSetObserver = new AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
        }
        this.layoutChildren();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed && !this.loadOnce) {
            scrollViewHeight = this.getHeight();
            this.scrollLayout = (LinearLayout)this.getChildAt(0);
            this.columnWidth = this.firstColumn.getWidth();
            this.loadOnce = true;
        }
    }

    protected void layoutChildren() {
        AbLogUtil.d(AbMultiColumnListView.class, "layoutChildren");
        this.firstColumn.removeAllViews();
        this.secondColumn.removeAllViews();
        this.thirdColumn.removeAllViews();
        this.mItems.clear();
        this.firstColumnHeight = 0;
        this.secondColumnHeight = 0;
        this.thirdColumnHeight = 0;
        if (this.mAdapter != null) {
            int mItemCount = this.mAdapter.getCount();
            int i = 0;
            while (i < mItemCount) {
                AbViewInfo viewInfo = this.mAdapter.getView(i, null, null);
                viewInfo.setVisible(0);
                this.findColumnToAdd(viewInfo);
                this.mItems.add(viewInfo);
                ++i;
            }
        }
    }

    protected void addChildren() {
        int count;
        AbLogUtil.d(AbMultiColumnListView.class, "addChildren");
        if (this.mAdapter != null && (count = this.mAdapter.getCount()) > this.mItems.size()) {
            int i = this.mItems.size();
            while (i < count) {
                AbViewInfo viewInfo = this.mAdapter.getView(i, null, null);
                viewInfo.setVisible(0);
                this.findColumnToAdd(viewInfo);
                this.mItems.add(viewInfo);
                ++i;
            }
        }
    }

    private void findColumnToAdd(AbViewInfo viewInfo) {
        int width = viewInfo.getWidth();
        int height = viewInfo.getHeight();
        int scaledHeight = 0;
        double ratio = (double)width / ((double)this.columnWidth * 1.0);
        scaledHeight = (int)((double)height / ratio);
        View view = viewInfo.getView();
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.columnWidth, scaledHeight);
        if (this.firstColumnHeight <= this.secondColumnHeight) {
            if (this.firstColumnHeight <= this.thirdColumnHeight) {
                viewInfo.setTop(this.firstColumnHeight);
                this.firstColumnHeight += scaledHeight;
                viewInfo.setBottom(this.firstColumnHeight);
                this.firstColumn.addView(view, (ViewGroup.LayoutParams)params);
            } else {
                viewInfo.setTop(this.thirdColumnHeight);
                this.thirdColumnHeight += scaledHeight;
                viewInfo.setBottom(this.thirdColumnHeight);
                this.thirdColumn.addView(view, (ViewGroup.LayoutParams)params);
            }
        } else if (this.secondColumnHeight <= this.thirdColumnHeight) {
            viewInfo.setTop(this.secondColumnHeight);
            this.secondColumnHeight += scaledHeight;
            viewInfo.setBottom(this.secondColumnHeight);
            this.secondColumn.addView(view, (ViewGroup.LayoutParams)params);
        } else {
            viewInfo.setTop(this.thirdColumnHeight);
            this.thirdColumnHeight += scaledHeight;
            viewInfo.setBottom(this.thirdColumnHeight);
            this.thirdColumn.addView(view, (ViewGroup.LayoutParams)params);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onScrollChanged(int x, int y, int oldx, int oldy) {
        super.onScrollChanged(x, y, oldx, oldy);
        viewInfo = null;
        i = 0;
        while (i < this.mItems.size()) {
            viewInfo = this.mItems.get(i);
            if (!this.checkVisibility(i)) {
                if (viewInfo.getVisible() == 0) {
                    viewInfo.setVisible(4);
                    imageView = null;
                    var11_12 = this.mReleaseImageResIds;
                    var10_11 = this.mReleaseImageResIds.length;
                    var9_10 = 0;
                    while (var9_10 < var10_11) {
                        id = var11_12[var9_10];
                        imageView = (ImageView)viewInfo.getView().findViewById(id);
                        imageView.setImageBitmap(null);
                        ++var9_10;
                    }
                }
            } else {
                try {
                    if (viewInfo.getVisible() != 4) ** GOTO lbl28
                    viewInfo = this.mAdapter.getView(i, viewInfo, null);
                    viewInfo.setVisible(0);
                }
                catch (Exception var7_8) {
                    // empty catch block
                }
            }
lbl28:
            // 4 sources

            ++i;
        }
        this.mOnScrollListener.onScrollChanged(x, y, oldx, oldy);
    }

    public boolean checkVisibility(int position) {
        AbViewInfo viewInfo = this.mItems.get(position);
        int borderTop = viewInfo.getTop();
        int borderBottom = viewInfo.getBottom();
        return borderBottom > this.getScrollY() && borderTop < this.getScrollY() + scrollViewHeight;
    }

    public OnScrollListener getOnScrollListener() {
        return this.mOnScrollListener;
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    public int[] getReleaseImageResIds() {
        return this.mReleaseImageResIds;
    }

    public void setReleaseImageResIds(int[] releaseImageResIds) {
        this.mReleaseImageResIds = releaseImageResIds;
    }

    class AdapterDataSetObserver
    extends DataSetObserver {
        AdapterDataSetObserver() {
        }

        public void onChanged() {
            AbLogUtil.d(AbMultiColumnListView.class, "onChanged");
            int count = AbMultiColumnListView.this.mAdapter.getCount();
            if (count > AbMultiColumnListView.this.mItems.size()) {
                AbMultiColumnListView.this.addChildren();
            } else {
                AbMultiColumnListView.this.layoutChildren();
            }
            super.onChanged();
        }

        public void onInvalidated() {
            super.onInvalidated();
        }
    }

    public static interface OnScrollListener {
        public void onScrollChanged(int var1, int var2, int var3, int var4);
    }
}

