/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class MathHelper {
    public static final double NULL_VALUE = Double.MAX_VALUE;
    private static final NumberFormat FORMAT = NumberFormat.getNumberInstance();

    private MathHelper() {
    }

    public static double[] minmax(List<Double> values) {
        double min;
        if (values.size() == 0) {
            return new double[2];
        }
        double max = min = values.get(0).doubleValue();
        int length = values.size();
        int i = 1;
        while (i < length) {
            double value = values.get(i);
            min = Math.min(min, value);
            max = Math.max(max, value);
            ++i;
        }
        return new double[]{min, max};
    }

    public static List<Double> getLabels(double start, double end, int approxNumLabels) {
        FORMAT.setMaximumFractionDigits(5);
        ArrayList<Double> labels = new ArrayList<Double>();
        double[] labelParams = MathHelper.computeLabels(start, end, approxNumLabels);
        int numLabels = 1 + (int)((labelParams[1] - labelParams[0]) / labelParams[2]);
        int i = 0;
        while (i < numLabels) {
            double z = labelParams[0] + (double)i * labelParams[2];
            try {
                z = FORMAT.parse(FORMAT.format(z)).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            labels.add(z);
            ++i;
        }
        return labels;
    }

    private static double[] computeLabels(double start, double end, int approxNumLabels) {
        if (Math.abs(start - end) < (double)1.0E-7f) {
            return new double[]{start, start, 0.0};
        }
        double s = start;
        double e = end;
        boolean switched = false;
        if (s > e) {
            switched = true;
            double tmp = s;
            s = e;
            e = tmp;
        }
        double xStep = MathHelper.roundUp(Math.abs(s - e) / (double)approxNumLabels);
        double xStart = xStep * Math.ceil(s / xStep);
        double xEnd = xStep * Math.floor(e / xStep);
        if (switched) {
            return new double[]{xEnd, xStart, -1.0 * xStep};
        }
        return new double[]{xStart, xEnd, xStep};
    }

    private static double roundUp(double val) {
        int exponent = (int)Math.floor(Math.log10(val));
        double rval = val * Math.pow(10.0, -exponent);
        if (rval > 5.0) {
            rval = 10.0;
        } else if (rval > 2.0) {
            rval = 5.0;
        } else if (rval > 1.0) {
            rval = 2.0;
        }
        return rval *= Math.pow(10.0, exponent);
    }

    public static float[] getFloats(List<Float> values) {
        int length = values.size();
        float[] result = new float[length];
        int i = 0;
        while (i < length) {
            result[i] = values.get(i).floatValue();
            ++i;
        }
        return result;
    }

    public static double[] getDoubles(List<Double> values) {
        int length = values.size();
        double[] result = new double[length];
        int i = 0;
        while (i < length) {
            result[i] = values.get(i);
            ++i;
        }
        return result;
    }

    public static int[] getInts(List<Integer> values) {
        int length = values.size();
        int[] result = new int[length];
        int i = 0;
        while (i < length) {
            result[i] = values.get(i);
            ++i;
        }
        return result;
    }
}

