/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.carousel;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Handler;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.Adapter;

public abstract class CarouselAdapter<T extends Adapter>
extends ViewGroup {
    public static final int ITEM_VIEW_TYPE_IGNORE = -1;
    public static final int ITEM_VIEW_TYPE_HEADER_OR_FOOTER = -2;
    @ViewDebug.ExportedProperty
    int mFirstPosition = 0;
    int mSpecificTop;
    int mSyncPosition;
    long mSyncRowId = Long.MIN_VALUE;
    long mSyncHeight;
    boolean mNeedSync = false;
    int mSyncMode;
    private int mLayoutHeight;
    static final int SYNC_SELECTED_POSITION = 0;
    static final int SYNC_FIRST_POSITION = 1;
    static final int SYNC_MAX_DURATION_MILLIS = 100;
    boolean mInLayout = false;
    OnItemSelectedListener mOnItemSelectedListener;
    OnItemClickListener mOnItemClickListener;
    OnItemLongClickListener mOnItemLongClickListener;
    boolean mDataChanged;
    @ViewDebug.ExportedProperty
    int mNextSelectedPosition = -1;
    long mNextSelectedRowId = Long.MIN_VALUE;
    @ViewDebug.ExportedProperty
    int mSelectedPosition = -1;
    long mSelectedRowId = Long.MIN_VALUE;
    private View mEmptyView;
    @ViewDebug.ExportedProperty
    int mItemCount;
    int mOldItemCount;
    public static final int INVALID_POSITION = -1;
    public static final long INVALID_ROW_ID = Long.MIN_VALUE;
    int mOldSelectedPosition = -1;
    long mOldSelectedRowId = Long.MIN_VALUE;
    private boolean mDesiredFocusableState;
    private boolean mDesiredFocusableInTouchModeState;
    private SelectionNotifier mSelectionNotifier;
    boolean mBlockLayoutRequests = false;

    public CarouselAdapter(Context context) {
        super(context);
    }

    public CarouselAdapter(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CarouselAdapter(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public final OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public boolean performItemClick(View view, int position, long id) {
        if (this.mOnItemClickListener != null) {
            this.playSoundEffect(0);
            this.mOnItemClickListener.onItemClick(this, view, position, id);
            return true;
        }
        return false;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.mOnItemLongClickListener = listener;
    }

    public final OnItemLongClickListener getOnItemLongClickListener() {
        return this.mOnItemLongClickListener;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
    }

    public final OnItemSelectedListener getOnItemSelectedListener() {
        return this.mOnItemSelectedListener;
    }

    public abstract T getAdapter();

    public abstract void setAdapter(T var1);

    public void addView(View child) {
        throw new UnsupportedOperationException("addView(View) is not supported in CarouselAdapter");
    }

    public void addView(View child, int index) {
        throw new UnsupportedOperationException("addView(View, int) is not supported in CarouselAdapter");
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("addView(View, LayoutParams) is not supported in CarouselAdapter");
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("addView(View, int, LayoutParams) is not supported in CarouselAdapter");
    }

    public void removeView(View child) {
        throw new UnsupportedOperationException("removeView(View) is not supported in CarouselAdapter");
    }

    public void removeViewAt(int index) {
        throw new UnsupportedOperationException("removeViewAt(int) is not supported in CarouselAdapter");
    }

    public void removeAllViews() {
        throw new UnsupportedOperationException("removeAllViews() is not supported in CarouselAdapter");
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mLayoutHeight = this.getHeight();
    }

    @ViewDebug.CapturedViewProperty
    public int getSelectedItemPosition() {
        return this.mNextSelectedPosition;
    }

    @ViewDebug.CapturedViewProperty
    public long getSelectedItemId() {
        return this.mNextSelectedRowId;
    }

    public abstract View getSelectedView();

    public Object getSelectedItem() {
        T adapter = this.getAdapter();
        int selection = this.getSelectedItemPosition();
        if (adapter != null && adapter.getCount() > 0 && selection >= 0) {
            return adapter.getItem(selection);
        }
        return null;
    }

    @ViewDebug.CapturedViewProperty
    public int getCount() {
        return this.mItemCount;
    }

    public int getPositionForView(View view) {
        View listItem = view;
        try {
            View v;
            while (!(v = (View)listItem.getParent()).equals((Object)this)) {
                listItem = v;
            }
        }
        catch (ClassCastException e) {
            return -1;
        }
        int childCount = this.getChildCount();
        int i = 0;
        while (i < childCount) {
            if (this.getChildAt(i).equals(listItem)) {
                return this.mFirstPosition + i;
            }
            ++i;
        }
        return -1;
    }

    public int getFirstVisiblePosition() {
        return this.mFirstPosition;
    }

    public int getLastVisiblePosition() {
        return this.mFirstPosition + this.getChildCount() - 1;
    }

    public abstract void setSelection(int var1);

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
        T adapter = this.getAdapter();
        boolean empty = adapter == null || adapter.isEmpty();
        this.updateEmptyStatus(empty);
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    boolean isInFilterMode() {
        return false;
    }

    public void setFocusable(boolean focusable) {
        T adapter = this.getAdapter();
        boolean empty = adapter == null || adapter.getCount() == 0;
        this.mDesiredFocusableState = focusable;
        if (!focusable) {
            this.mDesiredFocusableInTouchModeState = false;
        }
        super.setFocusable(focusable && (!empty || this.isInFilterMode()));
    }

    public void setFocusableInTouchMode(boolean focusable) {
        T adapter = this.getAdapter();
        boolean empty = adapter == null || adapter.getCount() == 0;
        this.mDesiredFocusableInTouchModeState = focusable;
        if (focusable) {
            this.mDesiredFocusableState = true;
        }
        super.setFocusableInTouchMode(focusable && (!empty || this.isInFilterMode()));
    }

    void checkFocus() {
        T adapter = this.getAdapter();
        boolean empty = adapter == null || adapter.getCount() == 0;
        boolean focusable = !empty || this.isInFilterMode();
        super.setFocusableInTouchMode(focusable && this.mDesiredFocusableInTouchModeState);
        super.setFocusable(focusable && this.mDesiredFocusableState);
        if (this.mEmptyView != null) {
            this.updateEmptyStatus(adapter == null || adapter.isEmpty());
        }
    }

    private void updateEmptyStatus(boolean empty) {
        if (this.isInFilterMode()) {
            empty = false;
        }
        if (empty) {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(0);
                this.setVisibility(8);
            } else {
                this.setVisibility(0);
            }
            if (this.mDataChanged) {
                this.onLayout(false, this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
            }
        } else {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(8);
            }
            this.setVisibility(0);
        }
    }

    public Object getItemAtPosition(int position) {
        T adapter = this.getAdapter();
        return adapter == null || position < 0 ? null : adapter.getItem(position);
    }

    public long getItemIdAtPosition(int position) {
        T adapter = this.getAdapter();
        return adapter == null || position < 0 ? Long.MIN_VALUE : adapter.getItemId(position);
    }

    public void setOnClickListener(View.OnClickListener l) {
        throw new RuntimeException("Don't call setOnClickListener for an CarouselAdapter. You probably want setOnItemClickListener instead");
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        this.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    void selectionChanged() {
        if (this.mOnItemSelectedListener != null) {
            if (this.mInLayout || this.mBlockLayoutRequests) {
                if (this.mSelectionNotifier == null) {
                    this.mSelectionNotifier = new SelectionNotifier();
                }
                this.mSelectionNotifier.post(this.mSelectionNotifier);
            } else {
                this.fireOnSelected();
            }
        }
        if (this.mSelectedPosition != -1 && this.isShown() && !this.isInTouchMode()) {
            this.sendAccessibilityEvent(4);
        }
    }

    private void fireOnSelected() {
        if (this.mOnItemSelectedListener == null) {
            return;
        }
        int selection = this.getSelectedItemPosition();
        if (selection >= 0) {
            View v = this.getSelectedView();
            this.mOnItemSelectedListener.onItemSelected(this, v, selection, this.getAdapter().getItemId(selection));
        } else {
            this.mOnItemSelectedListener.onNothingSelected(this);
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        View selectedView;
        boolean populated = false;
        if (event.getEventType() == 8) {
            event.setEventType(4);
        }
        if ((selectedView = this.getSelectedView()) != null) {
            populated = selectedView.dispatchPopulateAccessibilityEvent(event);
        }
        if (!populated) {
            if (selectedView != null) {
                event.setEnabled(selectedView.isEnabled());
            }
            event.setItemCount(this.getCount());
            event.setCurrentItemIndex(this.getSelectedItemPosition());
        }
        return populated;
    }

    protected boolean canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    void handleDataChanged() {
        int count = this.mItemCount;
        boolean found = false;
        if (count > 0) {
            int selectablePos;
            int newPos;
            if (this.mNeedSync) {
                this.mNeedSync = false;
                newPos = this.findSyncPosition();
                if (newPos >= 0 && (selectablePos = this.lookForSelectablePosition(newPos, true)) == newPos) {
                    this.setNextSelectedPositionInt(newPos);
                    found = true;
                }
            }
            if (!found) {
                newPos = this.getSelectedItemPosition();
                if (newPos >= count) {
                    newPos = count - 1;
                }
                if (newPos < 0) {
                    newPos = 0;
                }
                if ((selectablePos = this.lookForSelectablePosition(newPos, true)) < 0) {
                    selectablePos = this.lookForSelectablePosition(newPos, false);
                }
                if (selectablePos >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    this.checkSelectionChanged();
                    found = true;
                }
            }
        }
        if (!found) {
            this.mSelectedPosition = -1;
            this.mSelectedRowId = Long.MIN_VALUE;
            this.mNextSelectedPosition = -1;
            this.mNextSelectedRowId = Long.MIN_VALUE;
            this.mNeedSync = false;
            this.checkSelectionChanged();
        }
    }

    void checkSelectionChanged() {
        if (this.mSelectedPosition != this.mOldSelectedPosition || this.mSelectedRowId != this.mOldSelectedRowId) {
            this.selectionChanged();
            this.mOldSelectedPosition = this.mSelectedPosition;
            this.mOldSelectedRowId = this.mSelectedRowId;
        }
    }

    /*
     * Unable to fully structure code
     */
    int findSyncPosition() {
        count = this.mItemCount;
        if (count == 0) {
            return -1;
        }
        idToMatch = this.mSyncRowId;
        seed = this.mSyncPosition;
        if (idToMatch == -9223372036854775808L) {
            return -1;
        }
        seed = Math.max(0, seed);
        seed = Math.min(count - 1, seed);
        endTime = SystemClock.uptimeMillis() + 100L;
        first = seed;
        last = seed;
        next = false;
        adapter = this.getAdapter();
        if (adapter != null) ** GOTO lbl30
        return -1;
lbl-1000:
        // 1 sources

        {
            rowId = adapter.getItemId(seed);
            if (rowId == idToMatch) {
                return seed;
            }
            hitLast = last == count - 1;
            v0 = hitFirst = first == 0;
            if (hitLast && hitFirst) break;
            if (hitFirst || next && !hitLast) {
                seed = ++last;
                next = false;
                continue;
            }
            if (!hitLast && (next || hitFirst)) continue;
            seed = --first;
            next = true;
lbl30:
            // 4 sources

            ** while (SystemClock.uptimeMillis() <= endTime)
        }
lbl31:
        // 2 sources

        return -1;
    }

    int lookForSelectablePosition(int position, boolean lookDown) {
        return position;
    }

    void setSelectedPositionInt(int position) {
        this.mSelectedPosition = position;
        this.mSelectedRowId = this.getItemIdAtPosition(position);
    }

    void setNextSelectedPositionInt(int position) {
        this.mNextSelectedPosition = position;
        this.mNextSelectedRowId = this.getItemIdAtPosition(position);
        if (this.mNeedSync && this.mSyncMode == 0 && position >= 0) {
            this.mSyncPosition = position;
            this.mSyncRowId = this.mNextSelectedRowId;
        }
    }

    void rememberSyncState() {
        if (this.getChildCount() > 0) {
            this.mNeedSync = true;
            this.mSyncHeight = this.mLayoutHeight;
            if (this.mSelectedPosition >= 0) {
                View v = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                this.mSyncRowId = this.mNextSelectedRowId;
                this.mSyncPosition = this.mNextSelectedPosition;
                if (v != null) {
                    this.mSpecificTop = v.getTop();
                }
                this.mSyncMode = 0;
            } else {
                View v = this.getChildAt(0);
                T adapter = this.getAdapter();
                this.mSyncRowId = this.mFirstPosition >= 0 && this.mFirstPosition < adapter.getCount() ? adapter.getItemId(this.mFirstPosition) : -1L;
                this.mSyncPosition = this.mFirstPosition;
                if (v != null) {
                    this.mSpecificTop = v.getTop();
                }
                this.mSyncMode = 1;
            }
        }
    }

    public static class AdapterContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public View targetView;
        public int position;
        public long id;

        public AdapterContextMenuInfo(View targetView, int position, long id) {
            this.targetView = targetView;
            this.position = position;
            this.id = id;
        }
    }

    class AdapterDataSetObserver
    extends DataSetObserver {
        private Parcelable mInstanceState = null;

        AdapterDataSetObserver() {
        }

        public void onChanged() {
            CarouselAdapter.this.mDataChanged = true;
            CarouselAdapter.this.mOldItemCount = CarouselAdapter.this.mItemCount;
            CarouselAdapter.this.mItemCount = CarouselAdapter.this.getAdapter().getCount();
            if (CarouselAdapter.this.getAdapter().hasStableIds() && this.mInstanceState != null && CarouselAdapter.this.mOldItemCount == 0 && CarouselAdapter.this.mItemCount > 0) {
                CarouselAdapter.this.onRestoreInstanceState(this.mInstanceState);
                this.mInstanceState = null;
            } else {
                CarouselAdapter.this.rememberSyncState();
            }
            CarouselAdapter.this.checkFocus();
            CarouselAdapter.this.requestLayout();
        }

        public void onInvalidated() {
            CarouselAdapter.this.mDataChanged = true;
            if (CarouselAdapter.this.getAdapter().hasStableIds()) {
                this.mInstanceState = CarouselAdapter.this.onSaveInstanceState();
            }
            CarouselAdapter.this.mOldItemCount = CarouselAdapter.this.mItemCount;
            CarouselAdapter.this.mItemCount = 0;
            CarouselAdapter.this.mSelectedPosition = -1;
            CarouselAdapter.this.mSelectedRowId = Long.MIN_VALUE;
            CarouselAdapter.this.mNextSelectedPosition = -1;
            CarouselAdapter.this.mNextSelectedRowId = Long.MIN_VALUE;
            CarouselAdapter.this.mNeedSync = false;
            CarouselAdapter.this.checkSelectionChanged();
            CarouselAdapter.this.checkFocus();
            CarouselAdapter.this.requestLayout();
        }

        public void clearSavedState() {
            this.mInstanceState = null;
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(CarouselAdapter<?> var1, View var2, int var3, long var4);
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(CarouselAdapter<?> var1, View var2, int var3, long var4);
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(CarouselAdapter<?> var1, View var2, int var3, long var4);

        public void onNothingSelected(CarouselAdapter<?> var1);
    }

    private class SelectionNotifier
    extends Handler
    implements Runnable {
        private SelectionNotifier() {
        }

        @Override
        public void run() {
            if (CarouselAdapter.this.mDataChanged) {
                this.post(this);
            } else {
                CarouselAdapter.this.fireOnSelected();
            }
        }
    }
}

