/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.TextPaint;
import com.ab.util.AbStrUtil;
import java.util.ArrayList;
import java.util.List;

public final class AbGraphicUtil {
    public static int subStringLength(String str, int maxPix, TextPaint paint) {
        if (AbStrUtil.isEmpty(str)) {
            return 0;
        }
        int currentIndex = 0;
        int i = 0;
        while (i < str.length()) {
            String temp = str.substring(0, i + 1);
            float valueLength = paint.measureText(temp);
            if (valueLength > (float)maxPix) {
                currentIndex = i - 1;
                break;
            }
            if (valueLength == (float)maxPix) {
                currentIndex = i;
                break;
            }
            ++i;
        }
        if (currentIndex == 0) {
            currentIndex = str.length() - 1;
        }
        return currentIndex;
    }

    public static float getStringWidth(String str, TextPaint paint) {
        float strWidth = paint.measureText(str);
        return strWidth;
    }

    public static float getDesiredWidth(String str, TextPaint paint) {
        float strWidth = Layout.getDesiredWidth((CharSequence)str, (TextPaint)paint);
        return strWidth;
    }

    public static float getDesiredHeight(TextPaint paint) {
        Paint.FontMetrics fm = paint.getFontMetrics();
        return (float)Math.ceil(fm.descent - fm.ascent);
    }

    public static List<String> getDrawRowStr(String text, int maxWPix, TextPaint paint) {
        String[] texts = null;
        texts = text.indexOf("\n") != -1 ? text.split("\n") : new String[]{text};
        ArrayList<String> mStrList = new ArrayList<String>();
        int i = 0;
        while (i < texts.length) {
            String textLine = texts[i];
            while (true) {
                int endIndex;
                if ((endIndex = AbGraphicUtil.subStringLength(textLine, maxWPix, paint)) <= 0) {
                    mStrList.add(textLine);
                } else if (endIndex == textLine.length() - 1) {
                    mStrList.add(textLine);
                } else {
                    mStrList.add(textLine.substring(0, endIndex + 1));
                }
                if (textLine.length() <= endIndex + 1) break;
                textLine = textLine.substring(endIndex + 1);
            }
            ++i;
        }
        return mStrList;
    }

    public static int getDrawRowCount(String text, int maxWPix, TextPaint paint) {
        String[] texts = null;
        texts = text.indexOf("\n") != -1 ? text.split("\n") : new String[]{text};
        ArrayList<String> mStrList = new ArrayList<String>();
        int i = 0;
        while (i < texts.length) {
            String textLine = texts[i];
            while (true) {
                int endIndex;
                if ((endIndex = AbGraphicUtil.subStringLength(textLine, maxWPix, paint)) <= 0) {
                    mStrList.add(textLine);
                } else if (endIndex == textLine.length() - 1) {
                    mStrList.add(textLine);
                } else {
                    mStrList.add(textLine.substring(0, endIndex + 1));
                }
                if (textLine.length() <= endIndex + 1) break;
                textLine = textLine.substring(endIndex + 1);
            }
            ++i;
        }
        return mStrList.size();
    }

    public static int drawText(Canvas canvas, String text, int maxWPix, TextPaint paint, int left, int top) {
        if (AbStrUtil.isEmpty(text)) {
            return 1;
        }
        List<String> mStrList = AbGraphicUtil.getDrawRowStr(text, maxWPix, paint);
        int hSize = (int)AbGraphicUtil.getDesiredHeight(paint);
        int i = 0;
        while (i < mStrList.size()) {
            int x = left;
            int y = top + hSize / 2 + hSize * i;
            String textLine = mStrList.get(i);
            canvas.drawText(textLine, (float)x, (float)y, (Paint)paint);
            ++i;
        }
        return mStrList.size();
    }
}

