/*
 * Decompiled with CFR 0.152.
 */
package com.ab.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.ab.global.AbAppConfig;
import com.ab.image.AbImageCache;
import com.ab.image.toolbox.ImageLoader;
import com.ab.network.toolbox.RequestQueue;
import com.ab.network.toolbox.Volley;
import com.ab.network.toolbox.VolleyError;
import com.ab.util.AbLogUtil;
import com.ab.util.AbStrUtil;

public class AbImageLoader {
    private Context mContext = null;
    private int maxWidth;
    private int maxHeight;
    private int expiresTime;
    private Drawable loadingImage;
    private View loadingView;
    private Drawable errorImage;
    private Drawable emptyImage;
    private RequestQueue mQueue;
    private ImageLoader mImageLoader = null;

    public AbImageLoader(Context context) {
        this.mContext = context;
        this.expiresTime = AbAppConfig.IMAGE_CACHE_EXPIRES_TIME;
        this.mQueue = Volley.newRequestQueue(context);
        this.mImageLoader = new ImageLoader(this.mQueue, AbImageCache.getInstance());
        this.mImageLoader.setExpiresTime(this.expiresTime);
    }

    public static AbImageLoader newInstance(Context context) {
        AbImageLoader imageDownloader = new AbImageLoader(context);
        return imageDownloader;
    }

    public void display(final ImageView imageView, String url) {
        if (AbStrUtil.isEmpty(url)) {
            if (this.emptyImage != null) {
                if (this.loadingView != null) {
                    this.loadingView.setVisibility(4);
                }
                imageView.setVisibility(0);
                imageView.setImageDrawable(this.emptyImage);
            }
            return;
        }
        if (this.loadingView != null) {
            this.loadingView.setVisibility(0);
            imageView.setVisibility(4);
        } else if (this.loadingImage != null) {
            imageView.setImageDrawable(this.loadingImage);
            imageView.setVisibility(0);
        }
        imageView.setTag((Object)url);
        this.mImageLoader.get(url, new ImageLoader.ImageListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                if (AbImageLoader.this.errorImage != null) {
                    imageView.setImageDrawable(AbImageLoader.this.errorImage);
                }
                imageView.setVisibility(0);
                if (AbImageLoader.this.loadingView != null) {
                    AbImageLoader.this.loadingView.setVisibility(4);
                }
            }

            @Override
            public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                Bitmap bitmap = response.getBitmap();
                AbLogUtil.d(AbImageLoader.class, "\u83b7\u53d6\u5230\u56fe\u7247\uff1a" + bitmap);
                if (!response.getRequestUrl().equals(imageView.getTag())) {
                    return;
                }
                if (bitmap != null) {
                    imageView.setImageBitmap(bitmap);
                } else if (AbImageLoader.this.emptyImage != null) {
                    imageView.setImageDrawable(AbImageLoader.this.emptyImage);
                }
                if (AbImageLoader.this.loadingView != null) {
                    AbImageLoader.this.loadingView.setVisibility(4);
                }
                imageView.setVisibility(0);
            }
        }, this.maxWidth, this.maxHeight);
    }

    public void setLoadingImage(int resID) {
        this.loadingImage = this.mContext.getResources().getDrawable(resID);
    }

    public void setLoadingView(View view) {
        this.loadingView = view;
    }

    public void setErrorImage(int resID) {
        this.errorImage = this.mContext.getResources().getDrawable(resID);
    }

    public void setEmptyImage(int resID) {
        this.emptyImage = this.mContext.getResources().getDrawable(resID);
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public int getExpiresTime() {
        return this.expiresTime;
    }

    public void setExpiresTime(int expiresTime) {
        this.expiresTime = expiresTime;
    }
}

