/*
 * Decompiled with CFR 0.152.
 */
package com.ab.fragment;

import android.animation.Animator;
import android.app.DialogFragment;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;

public class AbSampleDialogFragment
extends DialogFragment {
    private int mTheme;
    private int mStyle;
    private View mContentView;
    private DialogInterface.OnCancelListener mOnCancelListener = null;
    private DialogInterface.OnDismissListener mOnDismissListener = null;
    private int mGravity;

    public static AbSampleDialogFragment newInstance(int style, int theme) {
        return AbSampleDialogFragment.newInstance(style, theme, 17);
    }

    public static AbSampleDialogFragment newInstance(int style, int theme, int gravity) {
        AbSampleDialogFragment f = new AbSampleDialogFragment();
        Bundle args = new Bundle();
        args.putInt("style", style);
        args.putInt("theme", theme);
        args.putInt("gravity", gravity);
        f.setArguments(args);
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mStyle = this.getArguments().getInt("style");
        this.mTheme = this.getArguments().getInt("theme");
        this.mGravity = this.getArguments().getInt("gravity");
        this.setStyle(this.mStyle, this.mTheme);
    }

    public void onCancel(DialogInterface dialog) {
        if (this.mOnCancelListener != null) {
            this.mOnCancelListener.onCancel(dialog);
        }
        super.onCancel(dialog);
    }

    public void onDismiss(DialogInterface dialog) {
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
        super.onDismiss(dialog);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.mContentView;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        Window window = this.getDialog().getWindow();
        WindowManager.LayoutParams attributes = window.getAttributes();
        attributes.gravity = this.mGravity;
        window.setLayout(-1, -1);
        window.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)"#88838B8B")));
        super.onActivityCreated(savedInstanceState);
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void setContentView(View mContentView) {
        this.mContentView = mContentView;
    }

    public DialogInterface.OnCancelListener getOnCancelListener() {
        return this.mOnCancelListener;
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        this.mOnCancelListener = onCancelListener;
    }

    public DialogInterface.OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public Animator onCreateAnimator(int transit, boolean enter, int nextAnim) {
        return super.onCreateAnimator(transit, enter, nextAnim);
    }
}

